import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  DeleteDateColumn,
  ManyToOne,
  OneToMany,
  JoinColumn,
} from 'typeorm';
import { User } from './user.entity';
import { Floor } from './floor.entity';
import { ProgramRoomInventoryMap } from './program-room-inventory-map.entity';

/**
 * Entity representing a room within a floor
 * Contains room details including occupancy, status, and type information
 */
@Entity('room')
export class Room {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ name: 'label', type: 'varchar', length: 255, nullable: false })
  label: string;

  @Column({ name: 'description', type: 'text', nullable: true })
  description: string;

  @Column({ name: 'floor_id', type: 'bigint', nullable: false })
  floorId: number;

  @Column({ name: 'room_number', type: 'varchar', length: 50, nullable: false })
  roomNumber: string;

  @Column({ name: 'occupancy', type: 'int', nullable: false })
  occupancy: number;

  @Column({ name: 'room_status', type: 'varchar', length: 50, nullable: false })
  roomStatus: string;

  @Column({ name: 'room_type', type: 'varchar', length: 50, nullable: false })
  roomType: string;

  @Column({ name: 'bed_type', type: 'varchar', length: 50, nullable: true })
  bedType: string;

  @Column({ name: 'remarks', type: 'text', nullable: true })
  remarks: string;

  @CreateDateColumn({ name: 'created_at', type: 'timestamp', nullable: false })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamp', nullable: true })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamp', nullable: true })
  deletedAt: Date;

  @Column({ name: 'created_by', type: 'bigint', nullable: false })
  createdById: number;

  @Column({ name: 'updated_by', type: 'bigint', nullable: true })
  updatedById: number;

  // Relationships
  @ManyToOne(() => Floor, (floor) => floor.rooms, { nullable: false })
  @JoinColumn({ name: 'floor_id' })
  floor: Floor;

  @ManyToOne(() => User, { nullable: false })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User;

  @OneToMany(() => ProgramRoomInventoryMap, (inventory) => inventory.room)
  programRoomInventoryMaps: ProgramRoomInventoryMap[];

  constructor(partial: Partial<Room>) {
    Object.assign(this, partial);
  }
}