import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  DeleteDateColumn,
  ManyToOne,
  OneToMany,
  JoinColumn,
} from 'typeorm';
import { User } from './user.entity';
import { ProgramRoomInventoryMap } from './program-room-inventory-map.entity';
import { RoomAllocationHistory } from './room-allocation-history.entity';
import { ProgramRegistration } from './program-registration.entity';

/**
 * Entity representing the allocation of rooms to program registrations
 * Contains bed position and remarks for specific room assignments
 */
@Entity('room_allocation')
export class RoomAllocation {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ name: 'program_room_inventory_map_id', type: 'bigint', nullable: false })
  programRoomInventoryMapId: number;

  @Column({ name: 'registration_id', type: 'bigint', nullable: false })
  registrationId: number;

  @Column({ name: 'remarks', type: 'text', nullable: true })
  remarks: string;

  @Column({ name: 'bed_position', type: 'int', nullable: true })
  bedPosition: number;

  @CreateDateColumn({ name: 'created_at', type: 'timestamp', nullable: false, default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamp', nullable: true, default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamp', nullable: true })
  deletedAt: Date;

  @Column({ name: 'created_by', type: 'bigint', nullable: false })
  createdById: number;

  @Column({ name: 'updated_by', type: 'bigint', nullable: true })
  updatedById: number;

  // Relationships
  @ManyToOne(() => ProgramRoomInventoryMap, (inventory) => inventory.roomAllocations, { nullable: false })
  @JoinColumn({ name: 'program_room_inventory_map_id' })
  programRoomInventoryMap: ProgramRoomInventoryMap;

  @ManyToOne(() => ProgramRegistration, { nullable: false })
  @JoinColumn({ name: 'registration_id' })
  registration: ProgramRegistration;

  @ManyToOne(() => User, { nullable: false })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User;

  @OneToMany(() => RoomAllocationHistory, (history) => history.roomAllocation)
  roomAllocationHistories: RoomAllocationHistory[];

  constructor(partial: Partial<RoomAllocation>) {
    Object.assign(this, partial);
  }
}