  import {
    Entity,
    PrimaryGeneratedColumn,
    Column,
    CreateDateColumn,
    UpdateDateColumn,
    ManyToOne,
    JoinColumn,
    DeleteDateColumn,
  } from 'typeorm';
  import { IdTypeEnum } from '../enum/proof-id-type.enum';
  import { TshirtSizeEnum } from '../enum/tshirt-size.enum';
  import { TravelStatusEnum } from '../enum/travel-status.enum';
  import { ProgramRegistration, User } from '../entities/index'
import { Auditable } from 'src/audit-history/decorators/auditable.decorator';
import { SkipAudit } from 'src/audit-history/decorators/skip-audit.decorator';
  
  @Entity('hdb_registration_travel_info')
  @Auditable()
  export class RegistrationTravelInfo {
    @PrimaryGeneratedColumn('increment', { type: 'bigint' })
    id: number;
  
    @Column({ name: 'registration_id', type: 'bigint' })
    registrationId: number;
  
    @Column({ name: 'id_type', type: 'enum', enum: IdTypeEnum })
    idType: IdTypeEnum;
  
    @Column({ name: 'id_number', type: 'varchar', length: 50 })
    idNumber: string;
  
  @Column({ name: 'id_picture_url', type: 'varchar', length: 500, nullable: true })
  idPictureUrl: string;

  @Column({ name: 'id_picture_signed_url', type: 'text', nullable: true })
  idPictureSignedUrl: string;

  @Column({ name: 'user_picture_url', type: 'varchar', length: 500, nullable: true })
  userPictureUrl: string;

  @Column({ name: 'id_back_picture_url', type: 'varchar', length: 500, nullable: true })
  idBackPictureUrl: string;

  @Column({ name: 'id_back_picture_signed_url', type: 'text', nullable: true })
  idBackPictureSignedUrl: string;

  @Column({ name: 'international_id_picture_url', type: 'varchar', length: 500, nullable: true })
  internationalIdPictureUrl: string;

  @Column({ name: 'passport_copy_picture_url', type: 'varchar', length: 500, nullable: true })
  passportCopyPictureUrl: string;

  @Column({ name: 'passport_copy_picture_signed_url', type: 'text', nullable: true })
  passportCopyPictureSignedUrl: string;

  @Column({ name: 'visa_copy_picture_url', type: 'varchar', length: 500, nullable: true })
  visaCopyPictureUrl: string;

  @Column({ name: 'visa_copy_picture_signed_url', type: 'text', nullable: true })
  visaCopyPictureSignedUrl: string; 

  @Column({ name: 'tshirt_size', type: 'enum', enum: TshirtSizeEnum, nullable: true })
  tshirtSize: TshirtSizeEnum;    @Column({
      name: 'travel_info_status',
      type: 'enum',
      enum: TravelStatusEnum,
      default: TravelStatusEnum.PENDING,
    })
    travelInfoStatus: TravelStatusEnum;

    @Column({ name: 'audit_ref_id', type: 'bigint', nullable: true })
    auditRefId: number;

    @Column({ name: 'parent_ref_id', type: 'bigint', nullable: true })
    parentRefId: number;
  
   @SkipAudit()
   @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
    createdAt: Date;
   
    @SkipAudit()
    @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
    updatedAt: Date;
  
    @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true, default: null })
    deletedAt: Date;
    
    @SkipAudit()
    @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
    @JoinColumn({ name: 'created_by' })
    createdBy: User;
  
    @SkipAudit()
    @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
    @JoinColumn({ name: 'updated_by' })
    updatedBy: User;
  
    @SkipAudit()
    @ManyToOne(() => ProgramRegistration, { nullable: false, onDelete: 'CASCADE' })
    @JoinColumn({ name: 'registration_id' })
    registration: ProgramRegistration;
  
    constructor(partial: Partial<RegistrationTravelInfo>) {
      Object.assign(this, partial);
    }
  }