import { Entity, PrimaryGeneratedColumn, Column, ManyToOne, JoinColumn } from 'typeorm';
import { RegistrationInvoiceDetail } from './registration-invoice-detail.entity';
import { InvoiceTypeEnum } from '../enum/invoice-type.enum';
import { Auditable } from 'src/audit-history/decorators/auditable.decorator';
import { SkipAudit } from 'src/audit-history/decorators/skip-audit.decorator';
import { User } from './user.entity';

@Entity('hdb_registration_invoice_einvoice_history')
@Auditable()
export class RegistrationInvoiceEinvoiceHistory {
  @PrimaryGeneratedColumn('increment', { type: 'int' })
  id: number;

  @Column({ name: 'invoice_id', type: 'bigint', nullable: true })
  invoiceId: number;

  @Column({ name: 'invoice_type', type: 'enum', enum: InvoiceTypeEnum, nullable: true })
  invoiceType: InvoiceTypeEnum;

  @Column({ name: 'zip', type: 'varchar', length: 10, nullable: true })
  zip: string;

  @Column({ name: 'gst_number', type: 'varchar', length: 50, nullable: true })
  gstNumber: string;

  @Column({ name: 'pan_number', type: 'varchar', length: 20, nullable: true })
  panNumber: string;

  @Column({ name: 'invoice_sequence_number', type: 'varchar', length: 50, nullable: true })
  invoiceSequenceNumber: string;

  @Column({ name: 'invoice_issued_date', type: 'timestamptz', nullable: true })
  invoiceIssuedDate: Date;

  @Column({ name: 'einvoice_qr_link', type: 'varchar', length: 1024, nullable: true })
  einvoiceQrLink: string;

  @Column({ name: 'einvoice_ack_date', type: 'varchar', length: 500, nullable: true })
  einvoiceAckDate: string;

  @Column({ name: 'einvoice_inv_ref_num', type: 'varchar', length: 1024, nullable: true })
  einvoiceInvRefNum: string;

  @Column({ name: 'einvoice_is_cancellable', type: 'boolean', nullable: true })
  einvoiceIsCancellable: boolean;

  @Column({ name: 'einvoice_status_formatted', type: 'varchar', length: 1024, nullable: true })
  einvoiceStatusFormatted: string;

  @Column({ name: 'einvoice_formatted_status', type: 'varchar', length: 500, nullable: true })
  einvoiceFormattedStatus: string;

  @Column({ name: 'einvoice_ack_number', type: 'varchar', length: 500, nullable: true })
  einvoiceAckNumber: string;

  @Column({ name: 'einvoice_status', type: 'varchar', length: 500, nullable: true })
  einvoiceStatus: string;

  @Column({ name: 'einvoice_pdf_url', type: 'varchar', length: 2048, nullable: true })
  einvoicePdfUrl: string;

  @Column({ name: 'created_at', type: 'timestamp' })
  createdAt: Date;

  @Column({ name: 'updated_at', type: 'timestamp', onUpdate: 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @Column({ name: 'created_by', type: 'int', nullable: true })
  createdBy: number;

  @Column({ name: 'updated_by', type: 'int', nullable: true })
  updatedBy: number;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'created_by' })
  createdByUser: User;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'updated_by' })
  updatedByUser: User;

  @SkipAudit()
  @ManyToOne(() => RegistrationInvoiceDetail, { nullable: true, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'invoice_id' })
  invoice: RegistrationInvoiceDetail;

  constructor(partial: Partial<RegistrationInvoiceEinvoiceHistory>) {
    Object.assign(this, partial);
  }
}
