import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  DeleteDateColumn,
  ManyToOne,
  OneToMany,
  JoinColumn,
} from 'typeorm';
import { User } from './user.entity';
import { Program } from './program.entity';
import { RegistrationGroupMap } from './registration-group-map.entity';

/**
 * Entity representing registration groups for programs and sub-programs
 * Contains group information for organizing multiple registrations together
 */
@Entity('registration_group')
export class RegistrationGroup {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ name: 'group_name', type: 'varchar', length: 255, nullable: false })
  groupName: string;

  @Column({ name: 'program_id', type: 'bigint', nullable: false })
  programId: number;

  @Column({ name: 'sub_program_id', type: 'bigint', nullable: true })
  subProgramId: number;

  @Column({ name: 'remarks', type: 'text', nullable: true })
  remarks: string;

  @CreateDateColumn({ name: 'created_at', type: 'timestamp', nullable: false })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamp', nullable: true })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamp', nullable: true })
  deletedAt: Date;

  @Column({ name: 'created_by', type: 'bigint', nullable: false })
  createdById: number;

  @Column({ name: 'updated_by', type: 'bigint', nullable: true })
  updatedById: number;

  // Relationships
  @ManyToOne(() => Program, { nullable: false })
  @JoinColumn({ name: 'program_id' })
  program: Program;

  @ManyToOne(() => Program, { nullable: true })
  @JoinColumn({ name: 'sub_program_id' })
  subProgram: Program;

  @ManyToOne(() => User, { nullable: false })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User;

  @OneToMany(() => RegistrationGroupMap, (groupMap) => groupMap.registrationGroup)
  registrationGroupMaps: RegistrationGroupMap[];

  constructor(partial: Partial<RegistrationGroup>) {
    Object.assign(this, partial);
  }
}