import { GenderEnum } from '../enum/gender.enum';
import { RegistrationStatusEnum } from '../enum/registration-status.enum';
import { RegistrationBasicStatusEnum } from '../enum/registration-basic-status.enum';
import { Column, CreateDateColumn, DeleteDateColumn, Entity, JoinColumn, ManyToOne, OneToMany, OneToOne, PrimaryGeneratedColumn, UpdateDateColumn } from 'typeorm';
import { Preference, Program, ProgramRegistrationGoodies, ProgramRegistrationRecommendations, ProgramRegistrationRmRating, ProgramRegistrationSwap, ProgramSession, RegistrationApproval, RegistrationCustomResponse, RegistrationInvoiceDetail, RegistrationPaymentDetail, RegistrationTravelInfo, SeekerProgramExperience, User } from '../entities/index'
import { RegistrationTravelPlan } from './registration-travel-plan.entity';
import { Auditable } from 'src/audit-history/decorators/auditable.decorator';
import { SkipAudit } from 'src/audit-history/decorators/skip-audit.decorator';
import { ParentalFormStatusEnum } from '../enum/parental-form-status.enum';
import { PersonTypeEnum } from '../enum/person-type.enum';
import { RegistrationPairMap } from './registration-pair-map.entity';
import { RoomAllocation } from './room-allocation.entity';

@Entity('hdb_program_registration')
@Auditable()
export class ProgramRegistration {
  @PrimaryGeneratedColumn('increment', { type: 'bigint' })
  id: number;

  @Column({ name: 'program_id', type: 'bigint', nullable: true })
  programId?: number | null;

  @ManyToOne(() => Program, { nullable: true })
  @JoinColumn({ name: 'program_id' })
  program: Program;

  @ManyToOne(() => ProgramSession, { nullable: false, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'program_session_id' })
  programSession: ProgramSession;

  @Column({ name: 'allocated_program_id', type: 'bigint', nullable: true })
  allocatedProgramId?: number | null;

  @ManyToOne(() => Program, { nullable: true })
  @JoinColumn({ name: 'allocated_program_id' })
  allocatedProgram?: Program | null;

  @Column({ name: 'allocated_session_id', type: 'bigint', nullable: true })
  allocatedSessionId?: number | null;

  @ManyToOne(() => ProgramSession, { nullable: true })
  @JoinColumn({ name: 'allocated_session_id' })
  allocatedSession?: ProgramSession | null;

  @Column({ name: 'user_id', type: 'bigint', nullable: true })
  userId: number;

  // @Column({ name: 'program_registration_seq_number', type: 'integer', nullable: true })
  // programRegistrationSeqNumber: number;

  @Column({ name: 'registration_seq_number', type: 'varchar', length: 50, nullable: true })
  registrationSeqNumber: string;

  @Column({ name: 'waiting_list_seq_number', type: 'integer', nullable: true })
  waitingListSeqNumber: number;

  @Column({ name: 'wait_list_registration_seq_number', type: 'varchar', length: 50, nullable: true })
  waitListRegistrationSeqNumber: string;

  @Column({
    name: 'registration_status',
    type: 'enum',
    enum: RegistrationStatusEnum,
    default: RegistrationStatusEnum.DRAFT,
  })
  registrationStatus: RegistrationStatusEnum;

  @Column({
    name: 'basic_details_status',
    type: 'enum',
    enum: RegistrationBasicStatusEnum,
    default: RegistrationBasicStatusEnum.DRAFT,
  })
  basicDetailsStatus: RegistrationBasicStatusEnum;

  @Column({ name: 'registration_date', type: 'timestamptz' })
  registrationDate: Date;

  @Column({ name: 'cancellation_date', type: 'timestamptz', nullable: true })
  cancellationDate: Date;

  @Column({ name: 'cancelled_by', type: 'bigint', nullable: true })
  cancelledBy: number;

  @Column({ name: 'cancellation_reason', type: 'varchar', length: 255, nullable: true })
  cancellationReason: string;

  @Column({ name: 'cancellation_comments', type: 'text', nullable: true })
  cancellationComments: string;

  @Column({ name: 'rm_contact', type: 'bigint', nullable: true })
  rmContact: number;

  @Column({ name: 'preferred_room_mate', type: 'varchar', length: 255, nullable: true })
  preferredRoomMate: string;

  @Column({ name: 'full_name', type: 'varchar', length: 255 })
  fullName: string;

  @Column({ name: 'gender', type: 'enum', enum: GenderEnum })
  gender: GenderEnum;

  @Column({ name: 'mobile_number', type: 'varchar', length: 20 })
  mobileNumber: string;

  @Column({ name: 'email_address', type: 'varchar', length: 255 })
  emailAddress: string;

  @Column({ name: 'dob', type: 'date', nullable: true })
  dob: Date;

  @Column({ name: 'city', type: 'varchar', length: 100, nullable: true })
  city: string;

  @Column({ name: 'country_name', type: 'varchar', length: 255, nullable: true })
  countryName: string;

  @Column({ name: 'last_hdb_attended', type: 'varchar', length: 255, nullable: true })
  lastHdbAttended: string;

  @Column({ name: 'hdb_association_since', type: 'varchar', length: 255, nullable: true })
  hdbAssociationSince: string;

  @Column({ name: 'other_infinitheism_contact', type: 'varchar', length: 255, nullable: true })
  otherInfinitheismContact: string;

  @Column({ name: 'other_city_name', type: 'varchar', length: 255, nullable: true })
  otherCityName: string;

  @Column({ name: 'notes', type: 'text', nullable: true })
  notes: string;

  @Column({ name: 'terms_accepted', type: 'boolean', default: false })
  termsAccepted: boolean;

  @Column({ name : 'rm_review', type: 'text', nullable: true })
  rmReview: string;


  @Column({name: 'no_of_hdbs', type: 'integer', default: 0})
  noOfHDBs: number;

  @Column({ name: 'user_profile_url', type: 'text' })
  profileUrl: string;

  @Column({ name: 'user_profile_signed_url', type: 'text', nullable: true })
  profileSignedUrl: string;

  @Column({ name: 'user_video_url', type: 'text', nullable: true })
  videoUrl: string;

  @Column({ name: 'user_video_signed_url', type: 'text', nullable: true })
  videoSignedUrl: string;

  @Column({ name: 'alternate_phone_number', type: 'varchar', length: 20, nullable: true })
  alternatePhoneNumber: string;

  @Column({ name: 'comments', type: 'text', nullable: true })
  comments: string;

  @Column({ name:"pro_forma_invoice_name", type: 'varchar', length: 255, nullable: true })
  proFormaInvoiceName: string;

  @Column({ name: 'pro_forma_invoice_address', type: 'text', nullable: true })
  proFormaInvoiceAddress: string;

  @Column({ name: 'pro_forma_invoice_pdf_url', type: 'text', nullable: true })
  proFormaInvoicePdfUrl: string;

  @Column({ name: 'proforma_invoice_seq_number', type: 'varchar', length: 255, nullable: true })
  proFormaInvoiceSeqNumber: string;

  @Column({ name: 'pro_forma_is_gst_registered', type: 'boolean', nullable: true })
  proFormaIsGstRegistered: boolean;

  @Column({ name: 'pro_forma_gst_number', type: 'varchar', length: 50, nullable: true })
  proFormaGstNumber: string;

  @Column({ name: 'pro_forma_zip', type: 'varchar', length: 10, nullable: true })
  proFormaZip: string;

  @Column({ name: 'is_free_seat', type: 'boolean', default: false })
  isFreeSeat: boolean;

  @Column({ name: 'invoice_confirmation', type: 'boolean', default: false })
  invoiceConfirmation: boolean;

  @Column({ name: 'audit_ref_id', type: 'bigint', nullable: true })
  auditRefId: number;

  @Column({ name: 'parent_ref_id', type: 'bigint', nullable: true })
  parentRefId: number;

  @Column({ name: 'average_rating', type: 'numeric', nullable: true })
  averageRating: number;

  @Column({ name: 'first_song_preference', type: 'varchar', length: 255, nullable: true })
  firstSongPreference: string;

  @Column({ name: 'second_song_preference', type: 'varchar', length: 255, nullable: true })
  secondSongPreference: string;

  @Column({ name: 'song_preferences', type: 'jsonb', nullable: true })
  songPreferences: any;

  @Column({ name: 'phone_number_type', type: 'varchar', length: 50, nullable: true })
  phoneNumberType: string;

  @Column({ name: 'phone_number_relation', type: 'varchar', length: 50, nullable: true })
  phoneNumberRelation: string;

  @Column({ name: 'other_relation', type: 'varchar', length: 100, nullable: true })
  otherRelation: string;

  @Column({ name: 'parental_form_pdf_url', type: 'text', nullable: true })
  parentalFormPdfUrl: string;

  @Column({ name: 'parental_form_status', type: 'enum', enum: ParentalFormStatusEnum })
  parentalFormStatus: ParentalFormStatusEnum;

  @Column({ name: 'person_type', type: 'enum', enum: PersonTypeEnum })
  personType: PersonTypeEnum;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP', onUpdate: 'CURRENT_TIMESTAMP' })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true, default: null })
  deletedAt: Date;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'user_id' })
  user: User;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'cancelled_by' })
  cancelledByUser: User;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'rm_contact' })
  rmContactUser: User;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'created_by' })
  createdBy: User;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'updated_by' })
  updatedBy: User;

  @SkipAudit()
  @OneToMany(() => RegistrationInvoiceDetail, (invoice) => invoice.registration)
  invoiceDetails: RegistrationInvoiceDetail[];

  @SkipAudit()
  @OneToMany(() => RegistrationPaymentDetail, (payment) => payment.registration)
  paymentDetails: RegistrationPaymentDetail[];

  @SkipAudit()
  @OneToMany(() => SeekerProgramExperience, (experience) => experience.registration)
  seekerProgramExperience: SeekerProgramExperience[];

  @SkipAudit()
  @OneToMany(() => RegistrationTravelInfo, (travelInfo) => travelInfo.registration)
  travelInfo: RegistrationTravelInfo[];

  @SkipAudit()
  @OneToMany(() => RegistrationTravelPlan, (travelPlans) => travelPlans.registration)
  travelPlans: RegistrationTravelPlan[];

  @SkipAudit()
  @OneToMany(() => ProgramRegistrationGoodies, (goodie) => goodie.registration)
  goodies: ProgramRegistrationGoodies[];

  @SkipAudit()
  @OneToMany(() => RegistrationCustomResponse, (customResponse) => customResponse.registration)
  customResponses: RegistrationCustomResponse[];

  @SkipAudit()
  @OneToMany(() => RegistrationApproval, (approval) => approval.registration)
  approvals: RegistrationApproval[];

  @SkipAudit()
  @OneToMany(() => Preference, (preference) => preference.registration)
  preferences: Preference[];

  @SkipAudit()
  @OneToMany(() => ProgramRegistrationRmRating, (rating) => rating.programRegistration)
  @JoinColumn({ name: 'program_registration_id' })
  ratings: ProgramRegistrationRmRating[];

  @SkipAudit()
  @OneToMany(() => ProgramRegistrationSwap, (swap) => swap.programRegistration)
  @JoinColumn({ name: 'program_registration_id' , referencedColumnName: 'id' })
  swapsRequests: ProgramRegistrationSwap[];

  @SkipAudit()
  @OneToMany(() => ProgramRegistrationRecommendations, (rec) => rec.registration)
  @JoinColumn({ name: 'id', referencedColumnName: 'registration_id' })
  recommendation: ProgramRegistrationRecommendations[];

  @SkipAudit()
  @OneToMany(() => RegistrationPairMap, (pairMap) => pairMap.registration, { cascade: true })
  registrationPairMaps: RegistrationPairMap[];

  @SkipAudit()
  @OneToMany(() => RoomAllocation, (roomAllocation) => roomAllocation.registration)
  roomAllocations: RoomAllocation[];

  constructor(partial: Partial<ProgramRegistration>) {
    Object.assign(this, partial);
  }
}