import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  DeleteDateColumn,
  ManyToOne,
  JoinColumn,
} from 'typeorm';
import { ProgramRegistration, User } from './index';
import { TshirtSizeEnum } from '../enum/tshirt-size.enum';
import { Auditable } from 'src/audit-history/decorators/auditable.decorator';
import { SkipAudit } from 'src/audit-history/decorators/skip-audit.decorator';

@Entity('hdb_program_registration_goodies')
@Auditable()
export class ProgramRegistrationGoodies {
  @PrimaryGeneratedColumn('increment', { name: 'id', type: 'bigint' })
  id: number;

  @Column({ name: 'registration_id', type: 'bigint' })
  registrationId: number;

  @Column({ name: 'notebook', type: 'boolean', nullable: true })
  notebook: boolean;

  @Column({ name: 'ratria_pillar_leonia', type: 'boolean', nullable: true })
  ratriaPillarLeonia: boolean;

  @Column({ name: 'flask', type: 'boolean', nullable: true })
  flask: boolean;

  @Column({ name: 'tshirt', type: 'boolean', nullable: true })
  tshirt: boolean;

  @Column({ name: 'jacket', type: 'boolean', nullable: true })
  jacket: boolean;

  @Column({ name: 'tshirt_size', type: 'enum', enum: TshirtSizeEnum, nullable: true })
  tshirtSize: TshirtSizeEnum;

  @Column({ name: 'jacket_size', type: 'enum', enum: TshirtSizeEnum, nullable: true })
  jacketSize: TshirtSizeEnum;

  @Column({ name: 'ratria_pillar_location', type: 'varchar', length: 100, nullable: true })
  ratriaPillarLocation: string;

  @Column({ name: 'ratria_pillar_other_location', type: 'varchar', length: 100, nullable: true })
  ratriaPillarOtherLocation: string;

  @Column({ name: 'audit_ref_id', type: 'bigint', nullable: true })
  auditRefId: number;

  @Column({ name: 'parent_ref_id', type: 'bigint', nullable: true })
  parentRefId: number;

  @SkipAudit()
  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @SkipAudit()
  @UpdateDateColumn({
    name: 'updated_at',
    type: 'timestamptz',
    default: () => 'CURRENT_TIMESTAMP',
    onUpdate: 'CURRENT_TIMESTAMP',
  })
  updatedAt: Date;

  @DeleteDateColumn({ name: 'deleted_at', type: 'timestamptz', nullable: true, default: null })
  deletedAt: Date;

  @SkipAudit()
  @Column({ name: 'created_by', type: 'bigint', nullable: true })
  createdById: number;

  @SkipAudit()
  @Column({ name: 'updated_by', type: 'bigint', nullable: true })
  updatedById: number;

  @SkipAudit()
  @ManyToOne(() => ProgramRegistration, { nullable: false, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'registration_id', referencedColumnName: 'id' })
  registration: ProgramRegistration;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'created_by', referencedColumnName: 'id' })
  createdBy: User;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'updated_by', referencedColumnName: 'id' })
  updatedBy: User;

  constructor(partial: Partial<ProgramRegistrationGoodies>) {
    Object.assign(this, partial);
  }
}