import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  ManyToOne,
  JoinColumn,
} from 'typeorm';
import { RegistrationPaymentDetail, User } from '../entities/index';
import { Auditable } from 'src/audit-history/decorators/auditable.decorator';
import { SkipAudit } from 'src/audit-history/decorators/skip-audit.decorator';
import { PaymentEditRequestStatus } from '../enum/payment-edit-request-status.enum';

@Entity('hdb_payment_change_request')
@Auditable()
export class PaymentEditRequest {
  @PrimaryGeneratedColumn('increment', { type: 'int' })
  id: number;

  @Column({ name: 'payment_id', type: 'bigint' })
  paymentId: number;

  @Column({ name: 'request_status', type: 'enum', enum: PaymentEditRequestStatus })
  requestStatus: PaymentEditRequestStatus;

  @Column({ name: 'requested_by', type: 'bigint' })
  requestedBy: number;

  @Column({ name: 'updated_by', type: 'bigint', nullable: true })
  updatedBy: number;

  @Column({ name: 'completed_by', type: 'bigint', nullable: true })
  completedBy: number;

  @SkipAudit()
  @CreateDateColumn({ name: 'created_at', type: 'timestamp' })
  createdAt: Date;

  @SkipAudit()
  @UpdateDateColumn({ name: 'updated_at', type: 'timestamp' })
  updatedAt: Date;

  @SkipAudit()
  @ManyToOne(() => RegistrationPaymentDetail, { nullable: false, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'payment_id' })
  payment: RegistrationPaymentDetail;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: false, onDelete: 'CASCADE' })
  @JoinColumn({ name: 'requested_by' })
  requestedByUser: User;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'updated_by' })
  updatedByUser: User;

  @SkipAudit()
  @ManyToOne(() => User, { nullable: true, onDelete: 'SET NULL' })
  @JoinColumn({ name: 'completed_by' })
  completedByUser: User;

  constructor(partial: Partial<PaymentEditRequest>) {
    Object.assign(this, partial);
  }
}
