// import and export all entities from the common/entities directory
import { Option } from './option.entity';
import { OptionCategory } from './option-category.entity';
import { User } from './user.entity';
import { Question } from './question.entity';
import { QuestionOptionMap } from './question-option.entity';
import { FormSection } from './form-section.entity';
import { Program } from './program.entity';
import { ProgramType } from './program-type.entity';
import { ProgramQuestion } from './program-question.entity';
import { ProgramSession } from './program-session.entity';
import { ProgramRegistration } from './program-registration.entity';
import { RegistrationApproval } from './registration-approval.entity';
import { RegistrationCustomResponse } from './registration-custom-response.entity';
import { RegistrationQuestionAnswer } from './registration-question-answer.entity';
import { RegistrationInvoiceDetail } from './registration-invoice-detail.entity';
import { RegistrationPaymentDetail } from './registration-payment-detail.entity';
import { RegistrationTravelInfo } from './registration-travel-info.entity';
import { RegistrationTravelPlan } from './registration-travel-plan.entity';
import { ProgramRegistrationFailure } from './program-registration-failure.entity';
import { UserRole } from './user-role.entity';
import { UserRoleMap } from './user-role-map.entity';
import { RegistrationPaymentDetailsHistory } from './registration-payment-details-history.entity';
import { CommunicationTrack } from './communication-track.entity';
import { Message } from './program-message.entity';
import { Preference } from './preference.entity';
import { ProgramRegistrationRmRatingType } from './program-registration-rm-rating-type.entity';
import { ProgramRegistrationRmRating } from './program-registration-rm-rating.entity';
import { ProgramRegistrationSwap } from './program-registration-swap.entity';
import { SwapRequestedProgram } from './swap-requested-program.entity';
import { Address } from './address.entity';
import { LookupData } from './lookup-data.entity';
import { UserSession } from './user-session.entity';
import { RegistrationApprovalTrack } from './registration-approval-track.entity';
import { FeatureFlag } from './feature-flag.entity';
import { ProgramRegistrationGoodies } from './program-registration-goodies.entity';
import { ProgramRegistrationRecommendations } from './program-registration-recommendations.entity';
import { CancellationReason } from './cancellation-reason.entity';
import { CommunicationTemplates } from './communication-templates.entity';
import { PaymentEditRequest } from './payment-edit-request.entity';
import { RegistrationInvoiceBasicHistory } from './registration-invoice-basic-history.entity';
import { RegistrationInvoiceEinvoiceHistory } from './registration-invoice-einvoice-history.entity';
import { UserProfileExtension } from './user-profile-extension.entity';
import { UserParticipationSummary } from './user-participation-summary.entity';
import { UserProgramExperience } from './user-program-experience.entity';
import { UserRegistrationMap } from './user-registration-map.entity';
import { SchedulerLog } from './scheduler-log.entity';
import { RoomAllocation } from './room-allocation.entity';
import { ProgramRoomInventoryMap } from './program-room-inventory-map.entity';
import { Room } from './room.entity';
import { RoomAllocationHistory } from './room-allocation-history.entity';
import { AuditHistoryLog } from './audit-history-log.entity';
import { AuditHistoryLogDetail } from './audit-history-log-detail.entity';
import { Block } from './block.entity';
import { Floor } from './floor.entity';
import { Venue } from './venue.entity';
import { RegistrationGroup } from './registration-group.entity';
import { RegistrationGroupMap } from './registration-group-map.entity';
import { RegistrationPair } from './registration-pair.entity';
import { RegistrationPairMap } from './registration-pair-map.entity';
import { SeekerProgramExperience } from './seeker-program-experience.entity';
export * from './option.entity';
export * from './option-category.entity';
export * from './user.entity';
export * from './question.entity';
export * from './question-option.entity';
export * from './program.entity';
export * from './program-type.entity';
export * from './form-section.entity';
export * from './program-question.entity';
export * from './program-session.entity';
export * from './program-registration.entity';
export * from './registration-approval.entity';
export * from './registration-custom-response.entity';
export * from './registration-question-answer.entity';
export * from './registration-invoice-detail.entity';
export * from './registration-payment-detail.entity';
export * from './registration-travel-info.entity';
export * from './registration-travel-plan.entity';
export * from './program-registration-failure.entity';
export * from './user-role.entity';
export * from './user-role-map.entity';
export * from './registration-payment-details-history.entity';
export * from './communication-track.entity';
export * from './preference.entity';
export * from './program-registration-rm-rating-type.entity';
export * from './program-registration-rm-rating.entity';
export * from './program-registration-swap.entity';
export * from './swap-requested-program.entity';
export * from './address.entity';
export * from './program-message.entity';
export * from './lookup-data.entity';
export * from './user-session.entity';
export * from './registration-approval-track.entity';
export * from './feature-flag.entity';
export * from './program-registration-goodies.entity';
export * from './program-registration-recommendations.entity';
export * from './cancellation-reason.entity';
export * from './communication-templates.entity';
export * from './user-profile-extension.entity';
export * from './user-participation-summary.entity';
export * from './user-program-experience.entity';
export * from './user-registration-map.entity';
export * from './scheduler-log.entity';
export * from './room-allocation.entity';
export * from './program-room-inventory-map.entity';
export * from './room.entity';
export * from './room-allocation-history.entity';
export * from './audit-history-log.entity';
export * from './audit-history-log-detail.entity';
export * from './block.entity';
export * from './floor.entity';
export * from './venue.entity';
export * from './registration-group.entity';
export * from './registration-group-map.entity';
export * from './registration-pair.entity';
export * from './registration-pair-map.entity';
export * from './seeker-program-experience.entity';

export const entities = [
  Option,
  OptionCategory,
  User,
  Question,
  QuestionOptionMap,
  Program,
  ProgramType,
  FormSection,
  ProgramQuestion,
  ProgramSession,
  ProgramRegistration,
  RegistrationApproval,
  RegistrationCustomResponse,
  RegistrationQuestionAnswer,
  RegistrationInvoiceDetail,
  RegistrationPaymentDetail,
  RegistrationTravelInfo,
  RegistrationTravelPlan,
  ProgramRegistrationFailure,
  UserRole,
  UserRoleMap,
  CommunicationTrack,
  Preference,
  RegistrationPaymentDetailsHistory,
  ProgramRegistrationRmRatingType,
  ProgramRegistrationRmRating,
  ProgramRegistrationSwap,
  SwapRequestedProgram,
  Address,
  Message,
  LookupData,
  UserSession,
  RegistrationApprovalTrack,
  FeatureFlag,
  ProgramRegistrationGoodies,
  ProgramRegistrationRecommendations,
  CancellationReason,
  CommunicationTemplates,
  PaymentEditRequest,
  RegistrationInvoiceBasicHistory,
  RegistrationInvoiceEinvoiceHistory,
  UserProfileExtension,
  UserParticipationSummary,
  UserProgramExperience,
  UserRegistrationMap,
  SchedulerLog,
  RoomAllocation,
  ProgramRoomInventoryMap,
  Room,
  RoomAllocationHistory,
  AuditHistoryLog,
  AuditHistoryLogDetail,
  Block,
  Floor,
  Venue,
  RegistrationGroup,
  RegistrationGroupMap,
  RegistrationPair,
  RegistrationPairMap,
  SeekerProgramExperience
];
