import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
} from 'typeorm';
import { CommunicationTypeEnum } from '../enum/communication-type.enum';
import { CommunicationTemplatesKeysEnum } from '../enum/communication-template-keys.enum';
import { CommunicationCategoryEnum } from '../enum/communication-category.enum'; // Assuming this enum exists

@Entity('hdb_communication_templates')
export class CommunicationTemplates {
  @PrimaryGeneratedColumn('increment', { type: 'bigint' })
  id: number;

  @Column({ name: 'template_id', type: 'text', nullable: false })
  templateId: string;

  @Column({ name: 'template_key', type: 'enum', enum: CommunicationTemplatesKeysEnum, nullable: false })
  templateKey: CommunicationTemplatesKeysEnum;

  @Column({ name: 'template_content', type: 'text', nullable: false })
  templateContent: string;

  @Column({ name: 'template_type', type: 'enum', enum: CommunicationTypeEnum, nullable: false })
  templateType: CommunicationTypeEnum;

  @Column({ name: 'category', type: 'enum', enum: CommunicationCategoryEnum, nullable: true })
  category: CommunicationCategoryEnum;

  @Column({ name: 'program_key', type: 'varchar', length: 100, nullable: true })
  programKey: string;

  @CreateDateColumn({ name: 'created_at', type: 'timestamptz', default: () => 'CURRENT_TIMESTAMP' })
  createdAt: Date;

  @UpdateDateColumn({
    name: 'updated_at',
    type: 'timestamptz',
    default: () => 'CURRENT_TIMESTAMP',
    onUpdate: 'CURRENT_TIMESTAMP',
  })
  updatedAt: Date;

  constructor(partial: Partial<CommunicationTemplates>) {
    Object.assign(this, partial);
  }
}