/**
 * Registration List View - Optimized Relations and Select Fields
 * 
 * Based on analysis of transformRegistrationListData() function in registration.service.ts
 * This configuration optimizes database queries by only loading required fields and relations.
 */


// REQUIRED RELATIONS
const REGISTRATION_LIST_REQUIRED_RELATIONS = [
  // User data for seekerName, userId, isOrgUser, userProgramExperiences
  'user',
  'user.programExperiences',
  'user.programExperiences.lookupData',
  'user.participationSummary',

  
  // Program data for programId, blessedWith
  'program',
  
  // Session data for programSessionId
  'programSession',
  
  // Allocated program for blessedWith, allocatedProgramStartsAt, goodiesStatus
  'allocatedProgram',
  
  // Approvals for approvalStatus, blessedDate, goodiesStatus
  'approvals',
  
  // Payment details for paymentStatus
  'paymentDetails',
  
  // Invoice details for invoiceStatus, invoiceNumber, invoiceUrl
  'invoiceDetails',
  
  // Travel plans for travelPlanStatus, travelUpdatedAt
  'travelPlans',

  // Travel Info
  'travelInfo',

  // Swap requests for all swap-related fields
  'swapsRequests',
  'swapsRequests.swapRequestedProgram',
  'swapsRequests.swapRequestedProgram.program',
  'swapsRequests.currentProgram',
  'swapsRequests.requestedPrograms',
  
  // RM Contact for rmContact
  'rmContactUser',
  
  // Ratings for averageRating, ratings
  'ratings',
  
  // Preferences for preference field
  'preferences',
  'preferences.preferredProgram',
  'preferences.preferredSession',
  
  // Recommendations for recommendation, recommendationComments, followUpCount
  'recommendation',
  
  // Goodies for all goodies-related fields
  'goodies'
];

// SELECT FIELDS (Registration Entity)
const REGISTRATION_LIST_SELECT_FIELDS = [
  'id',
  'fullName',
  'dob',
  'gender',
  'city',
  'otherCityName',
  'noOfHDBs',
  'rmReview',
  'mobileNumber',
  'registrationStatus',
  'averageRating',
  'profileUrl',
  'emailAddress',
  'registrationDate',
  'updatedAt',
  'countryName',
  'hdbAssociationSince',
  'cancellationReason',
  'cancellationComments',
  'cancellationDate',
  'proFormaInvoicePdfUrl',
  'preferredRoomMate',
  'otherInfinitheismContact',
  'lastHdbAttended',
  'personType',
  'parentalFormStatus',
  'isFreeSeat',
  'comments'
];

// RELATION SELECT FIELDS
const REGISTRATION_LIST_RELATION_SELECT = {
  // User fields
  'user': ['id', 'userType'],
  'user.programExperiences': ['id', 'deletedAt'],
  'user.programExperiences.lookupData': ['id', 'lookupLabel', 'lookupKey', 'lookupOrder'],
  'user.participationSummary': ['id', 'programName', 'subProgramName','subProgramType', 'programId'],
  
  // Program fields
  'program': ['id', 'name', 'startsAt', 'endsAt', 'registrationEndsAt', 'registrationStartsAt'],
  'programSession': ['id'],
  'allocatedProgram': ['id', 'name', 'startsAt', 'endsAt', 'registrationEndsAt', 'registrationStartsAt'],
  
  // Approval fields
  'approvals': ['id','approvalStatus', 'approvalDate', 'updatedAt'],
  
  // Payment fields
  'paymentDetails': ['id', 'paymentStatus', 'paymentMode', 'originalAmount', 'offlineMeta', 'updatedAt', 'paymentDate'],
  
  // Invoice fields
  'invoiceDetails': ['id', 'invoiceStatus', 'invoiceSequenceNumber', 'invoicePdfUrl'],

  // Travel fields
  'travelPlans': ['id', 'travelPlanStatus', 'updatedAt'],

  // Travel Info fields
  'travelInfo': ['id', 'travelInfoStatus', 'updatedAt'],
  
  // Swap request fields
  'swapsRequests': ['id', 'type', 'status', 'swapRequirement', 'comment', 'swapRequirement', 'createdAt', 'updatedAt'],
  'swapsRequests.swapRequestedProgram': ['id'],
  'swapsRequests.swapRequestedProgram.program': ['id', 'name', 'startsAt', 'endsAt', 'registrationEndsAt', 'registrationStartsAt'],
  'swapsRequests.currentProgram': ['id', 'name', 'startsAt', 'endsAt', 'registrationEndsAt', 'registrationStartsAt'],
  'swapsRequests.requestedPrograms': ['id', 'name', 'startsAt', 'endsAt', 'registrationEndsAt', 'registrationStartsAt'],
  
  // RM Contact fields
  'rmContactUser': ['id', 'orgUsrName'],
  
  // Rating fields
  'ratings': ['id', 'rating', 'ratingKey'],
  
  // Preference fields
  'preferences': ['id', 'priorityOrder'],
  'preferences.preferredProgram': ['id', 'name', 'startsAt', 'endsAt', 'registrationEndsAt'],
  'preferences.preferredSession': ['id'],
  
  // Recommendation fields
  'recommendation': ['id', 'isRecommended', 'recommendationText', 'recommendationKey', 'followUpCount'],
  
  // Goodies fields
  'goodies': [
    'id',
    'tshirt',
    'tshirtSize', 
    'jacket',
    'jacketSize',
    'ratriaPillarLeonia',
    'ratriaPillarLocation',
    'ratriaPillarOtherLocation',
    'flask',
    'notebook'
  ]
};

export {
  REGISTRATION_LIST_REQUIRED_RELATIONS,
  REGISTRATION_LIST_SELECT_FIELDS,
  REGISTRATION_LIST_RELATION_SELECT
};