import { Injectable } from '@nestjs/common';
import { CancellationReasonRepository } from './cancellation-reason.repository';
import { AppLoggerService } from 'src/common/services/logger.service';
import { cancellationReasonConstMessages } from 'src/common/constants/strings-constants';
import { handleKnownErrors } from 'src/common/utils/handle-error.util';
import { ERROR_CODES } from 'src/common/constants/error-string-constants';

@Injectable()
export class CancellationReasonService {
  constructor(
    private readonly repository: CancellationReasonRepository,
    private readonly logger: AppLoggerService,
  ) {}

  async findActive() {
    this.logger.log(cancellationReasonConstMessages.FINDING_ACTIVE);
    try {
      return await this.repository.findActive();
    } catch (error) {
      handleKnownErrors(ERROR_CODES.CANCELLATION_REASON_GET_FAILED, error);
    }
  }
}
