import { Injectable } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { CancellationReason } from 'src/common/entities/cancellation-reason.entity';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { cancellationReasonConstMessages } from 'src/common/constants/strings-constants';
import { CommonStatus } from 'src/common/enum/common-status.enum';
import { handleKnownErrors } from 'src/common/utils/handle-error.util';
import { ERROR_CODES } from 'src/common/constants/error-string-constants';

@Injectable()
export class CancellationReasonRepository {
  constructor(
    @InjectRepository(CancellationReason)
    private readonly repo: Repository<CancellationReason>,
    private readonly commonDataService: CommonDataService,
    private readonly logger: AppLoggerService,
  ) {}

  async findActive() {
    this.logger.log(cancellationReasonConstMessages.FINDING_ACTIVE);
    try {
      const reasons = await this.commonDataService.findByData(this.repo, {
        status: CommonStatus.ACTIVE,
      });
      const data = reasons.map((item) => ({
        key: item.key,
        displayName: item.displayName,
        description: item.description,
      }));
      const total = data.length;
      return {
        data,
        pagination: {
          totalPages: 1,
          pageNumber: 1,
          pageSize: total + 1,
          totalRecords: total,
          numberOfRecords: total,
        },
      };
    } catch (error) {
      handleKnownErrors(ERROR_CODES.CANCELLATION_REASON_GET_FAILED, error);
    }
  }
}
