import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { CancellationReason } from 'src/common/entities/cancellation-reason.entity';
import { CancellationReasonService } from './cancellation-reason.service';
import { CancellationReasonController } from './cancellation-reason.controller';
import { CancellationReasonRepository } from './cancellation-reason.repository';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([CancellationReason]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
  ],
  controllers: [CancellationReasonController],
  providers: [CancellationReasonService, CancellationReasonRepository],
})
export class CancellationReasonModule {}
