import { ApiProperty } from '@nestjs/swagger';
import { IsString, IsNotEmpty, IsEnum, IsOptional, IsInt } from 'class-validator';
import { UserImageTypeEnum } from 'src/common/enum/user-image-type.enum';

export class CreateAwsHandlingDto {}

export class UploadFileDto {
    @ApiProperty({
        description: 'Name of the file to be uploaded',
        example: 'example.mp4',
    })
    @IsString()
    @IsNotEmpty({ message: 'File name is required' })
    fileName: string;

    @ApiProperty({
        description: 'Content type of the file',
        example: 'video/mpeg',
    })
    @IsString()
    @IsNotEmpty({ message: 'Content type is required' })
    contentType: string;

    @IsOptional()
    @ApiProperty({
        description: 'Type of image to upload',
        enum: UserImageTypeEnum,
        example: UserImageTypeEnum.PROFILE,
    })
    @IsEnum(UserImageTypeEnum)
    imageType: UserImageTypeEnum;

    @ApiProperty({ required: false })
    @IsOptional()
    @IsString({ message: 'Program CODE must be a valid string if provided' })
    programCode?: string;

    @ApiProperty({ required: false })
    @IsOptional()
    @IsInt({ message: 'User ID must be a valid integer if provided' })
    userId?: number;
}