import { forwardRef, Module } from '@nestjs/common';
import { AwsHandlingController } from './aws-handling.controller';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { AppLoggerService } from 'src/common/services/logger.service';
import { AwsS3Service } from 'src/common/services/awsS3.service';
import { ConfigModule } from '@nestjs/config';

@Module({
   imports: [
      ConfigModule,
      forwardRef(() => AuthModule),
      forwardRef(() => UserModule),
    ], 
  controllers: [AwsHandlingController],
  providers: [AwsS3Service, AppLoggerService],
})
export class AwsHandlingModule {}
