import { forwardRef, Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { FirebaseAuthService } from './firebase-auth.service';
import { UserModule } from 'src/user/user.module';
import { AuthService } from './auth.service';
import { AuthRepository } from './auth.repository';
import { UserSession, User } from 'src/common/entities';
import { ResponseService } from 'src/common/response-handling/response-handler';
import { OtpAuthGuard } from './otp-auth.guard';
import { AuthController } from './auth.controller';
import { CommunicationModule } from 'src/communication/communication.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([UserSession, User]),
    forwardRef(() => UserModule),
    CommunicationModule,
  ],
  controllers: [AuthController],
  providers: [FirebaseAuthService, AuthService, AuthRepository, ResponseService, OtpAuthGuard],
  exports: [FirebaseAuthService, AuthService, OtpAuthGuard],
})
export class AuthModule {}