import { Controller, Get, Param, Query } from '@nestjs/common';
import { AuditHistoryService } from '../services/audit-history.service';
import { RegistrationActivityQueryDto } from '../dto/registration-activity-query.dto';
import { ApiTags, ApiOperation, ApiParam, ApiQuery, ApiResponse } from '@nestjs/swagger';
import { IntelligentActivityResponse } from '../interfaces/intelligent-activity.interface';

@ApiTags('audit-history')
@Controller('audit-history')
export class AuditHistoryController {
  constructor(private readonly auditHistoryService: AuditHistoryService) {}

  @Get('registrations/:registrationId/activity-log')
  @ApiOperation({ 
    summary: 'Get intelligent registration activity log grouped by API calls (requestId)',
    description: 'Returns intelligent activity messages based on entity combinations and actions. Supports swap analysis, rating/recommendation tracking, payment processing, travel information, registration updates, approval changes, and cancellation detection.'
  })
  @ApiParam({ name: 'registrationId', description: 'Registration ID' })
  @ApiQuery({ name: 'startDate', required: false, description: 'Start date filter (ISO format)' })
  @ApiQuery({ name: 'endDate', required: false, description: 'End date filter (ISO format)' })
  @ApiResponse({ 
    status: 200, 
    description: 'Intelligent activity log retrieved successfully'
  })
  async getIntelligentActivityLog(
    @Param('registrationId') registrationId: string,
    @Query() query: RegistrationActivityQueryDto,
  ): Promise<IntelligentActivityResponse> {
    return this.auditHistoryService.getIntelligentActivityLog(registrationId, query);
  }
}
