import { Module, Global, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { APP_INTERCEPTOR } from '@nestjs/core';
import { AuditHistorySubscriber } from './subscribers/audit-history.subscriber';
import { AuditHistoryContextInterceptor } from './interceptors/audit-history-context.interceptor';
import { UserTraceInterceptor } from './interceptors/user-trace.interceptor';
import { AuditHistoryService } from './services/audit-history.service';
import { AuditHistoryContextService } from './audit-history-context.service';
import { AuditHistoryLog } from 'src/common/entities/audit-history-log.entity';
import { AuditHistoryLogDetail } from 'src/common/entities/audit-history-log-detail.entity';
import { AuditHistoryController } from './controllers/audit-history.controller';
import { UserModule } from 'src/user/user.module';
import { ProgramModule } from 'src/program/program.module';

@Global()
@Module({
  imports: [
    TypeOrmModule.forFeature([AuditHistoryLog, AuditHistoryLogDetail]),
    forwardRef(() => UserModule),
    forwardRef(() => ProgramModule),
  ],
  controllers: [AuditHistoryController],
  providers: [
    AuditHistoryService,
    AuditHistorySubscriber,
    AuditHistoryContextService,
    {
      provide: APP_INTERCEPTOR,
      useClass: AuditHistoryContextInterceptor,
    },
    {
      provide: APP_INTERCEPTOR,
      useClass: UserTraceInterceptor,
    },
  ],
  exports: [AuditHistoryService, AuditHistoryContextService],
})
export class AuditHistoryModule {}
