export const AUDIT_CONTEXT_KEY = 'auditHistoryContext';
export const AUDITABLE_KEY = Symbol('auditable');
export const SKIP_AUDIT_KEY = Symbol('skipAudit');

export enum AuditHistoryAction {
  INSERT = 'INSERT',
  UPDATE = 'UPDATE',
  DELETE = 'DELETE',
}

export enum AuditHistoryLogType {
  AUDIT = 'Audit',
  TRACE = 'Trace',
}

/**
 * Subcategories to exclude from activity log API responses
 * These activities are still logged in the database but filtered out from the response
 */
export const EXCLUDED_ACTIVITY_SUBCATEGORIES: string[] = [
  'seeker_program_experience_viewed',
];
