import { Injectable, OnModuleInit } from '@nestjs/common';
import { DataSource } from 'typeorm';

@Injectable()
export class AppService implements OnModuleInit {
  constructor(private readonly dataSource: DataSource) {}

  async onModuleInit() {
    try {
      await this.dataSource.query('SELECT 1');
      console.log('Database connection established successfully.');
    } catch (error) {
      console.error('Failed to connect to the database:', error.message);
    }
  }
  getHello(): string {
    return 'Hello World!';
  }
}
