-- ================================================================================================
-- HDB/MSD 2025-26 PROGRAM INSERT SCRIPT
-- ================================================================================================

-- ================================================================================================
-- 1. INSERT MAIN PROGRAM (HDB/MSD 2025-26)
-- ================================================================================================

INSERT INTO program_v1 (
    program, 
    program_type_id, 
    name, 
    description, 
    mode_of_operation, 
    online_type,
    max_session_duration_days, 
    has_multiple_sessions, 
    frequency, 
    default_start_time, 
    default_end_time,
    duration, 
    requires_residence, 
    involves_travel, 
    has_checkin_checkout, 
    requires_payment,
    requires_attendance_all_sessions, 
    allows_minors, 
    allows_proxy_registration, 
    requires_approval,
    registration_level, 
    waitlist_applicable, 
    limited_seats, 
    is_grouped_program, 
    no_of_session,
    max_capacity, 
    total_seats, 
    waitlist_trigger_count, 
    available_seats, 
    filled_seats,
    base_price, 
    gst_percentage, 
    cgst, 
    sgst, 
    igst, 
    tds_percent,
    gst_number, 
    tds_applicability, 
    invoice_sender_name, 
    invoice_sender_pan, 
    invoice_sender_cin,
    invoice_sender_address, 
    helpline_number, 
    email_sender_name, 
    venue_name_in_emails,
    currency, 
    venue, 
    status, 
    is_active, 
    code, 
    banner_image_url, 
    banner_animation_url,
    logo_url, 
    meta, 
    created_at, 
    updated_at, 
    created_by, 
    updated_by,
    is_approval_required, 
    is_residence_required, 
    is_travel_involved, 
    group_id,
    is_primary_program, 
    primary_program_id, 
    group_display_order, 
    registration_starts_at,
    registration_ends_at, 
    checkin_at, 
    checkout_at, 
    starts_at, 
    ends_at,
    launch_date, 
    checkin_ends_at, 
    checkout_ends_at,
    child_max_age,
    elder_min_age,
    sub_program_type
) VALUES (
    '2025-26',
    (SELECT id FROM program_type_v1 WHERE key = 'PT_HDBMSD'), -- Get PT_HDBMSD program_type_id dynamically
    'HDB/MSD 2025-26',
    'A residential spiritual retreat with Mahatria',
    'offline',
    'NA',
    8,
    TRUE,
    'yearly',
    '09:00:00',
    '18:00:00',
    '8 days',
    TRUE,
    TRUE,
    TRUE,
    TRUE,
    TRUE,
    FALSE,
    FALSE,
    TRUE,
    'program',
    FALSE,
    TRUE,
    TRUE,
    0,
    1000,
    1000,
    0,
    1000,
    0,
    1,
    18.00,
    9.00,
    9.00,
    18.00,
    10.00,
    '36AACCI7694H1Z5',
    'base_only',
    'HDB/MSD 2025-26',
    'AACCI7694H',
    'U74900TN2011PTC083263',
    'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India.',
    '+91 98416 70000',
    'HDB/MSD 2025-26',
    'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
    'INR',
    'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
    'active',
    TRUE,
    'HDB',
    'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/MSD.png',
    'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/hdb-banner-animation.webm',
    'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/logo/hdb-logo.svg',
    '{"price":[{"HDB":2},{"MSD":1}]}',
    NOW(),
    NOW(),
    -2,
    -2,
    TRUE,
    TRUE,
    TRUE,
    gen_random_uuid(),
    TRUE,
    NULL,
    1,
    '2025-08-23T00:00:00.000Z',
    '2025-09-25T18:29:59.000Z',
    '2025-11-17T09:30:00.000Z',
    '2026-02-06T22:30:00.000Z',
    '2025-11-17T03:30:00.000Z',
    '2026-02-06T11:30:00.000Z',
    '2025-11-17T03:30:00.000Z',
    '2025-11-17T15:00:00.000Z',
    '2026-02-07T02:30:00.000Z',
    15,
    80,
    NULL
);

-- ================================================================================================
-- 2. INSERT SUB-PROGRAMS (MSD 1, HDB 1, MSD 2, HDB 2, HDB 3)
-- ================================================================================================

-- Get the main program ID for reference
DO $$
DECLARE
    main_program_id INTEGER;
    main_group_id UUID;
BEGIN
    -- Get the main program details
    SELECT id, group_id INTO main_program_id, main_group_id
    FROM program_v1 
    WHERE name = 'HDB/MSD 2025-26' AND code = 'HDB';

    -- Insert MSD 1
    INSERT INTO program_v1 (
        program, program_type_id, name, description, mode_of_operation, online_type,
        max_session_duration_days, has_multiple_sessions, frequency, default_start_time, default_end_time,
        duration, requires_residence, involves_travel, has_checkin_checkout, requires_payment,
        requires_attendance_all_sessions, allows_minors, allows_proxy_registration, requires_approval,
        registration_level, waitlist_applicable, limited_seats, is_grouped_program, no_of_session,
        max_capacity, total_seats, waitlist_trigger_count, available_seats, filled_seats,
        base_price, gst_percentage, cgst, sgst, igst, tds_percent, gst_number, tds_applicability,
        invoice_sender_name, invoice_sender_pan, invoice_sender_cin, invoice_sender_address,
        helpline_number, email_sender_name, venue_name_in_emails, currency, venue, status, is_active,
        code, banner_image_url, banner_animation_url, logo_url, meta, created_at, updated_at,
        created_by, updated_by, is_approval_required, is_residence_required, is_travel_involved,
        group_id, is_primary_program, primary_program_id, group_display_order,
        registration_starts_at, registration_ends_at, checkin_at, checkout_at, starts_at, ends_at,
        launch_date, checkin_ends_at, checkout_ends_at, child_max_age, elder_min_age, sub_program_type
    ) VALUES (
        '2025-26', (SELECT id FROM program_type_v1 WHERE key = 'PT_HDBMSD'), 'MSD 1', 'A residential spiritual retreat with Mahatria', 'offline', 'NA',
        6, TRUE, 'yearly', '09:00:00', '18:00:00', '6 days', TRUE, TRUE, TRUE, TRUE,
        TRUE, FALSE, FALSE, TRUE, 'program', FALSE, TRUE, FALSE, 0,
        200, 200, 0, 200, 0, 1, 18.00, 9.00, 9.00, 18.00, 10.00,
        '36AACCI7694H1Z5', 'base_only', 'HDB/MSD 2025-26', 'AACCI7694H', 'U74900TN2011PTC083263',
        'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India.',
        '+91 98416 70000', 'HDB/MSD 2025-26', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'INR', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'active', TRUE, 'MSD', 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/MSD.png',
        'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/hdb-banner-animation.webm',
        'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/logo/hdb-logo.svg',
        '{}', NOW(), NOW(), -2, -2, TRUE, TRUE, TRUE, main_group_id, FALSE, main_program_id, 2,
        '2025-08-23T00:00:00.000Z', '2025-06-25T18:29:59.000Z', '2025-11-17T09:30:00.000Z', '2025-11-22T22:30:00.000Z',
        '2025-11-17T03:30:00.000Z', '2025-11-22T11:30:00.000Z', '2025-11-17T03:30:00.000Z',
        '2025-11-17T15:00:00.000Z', '2025-11-23T02:30:00.000Z', 15, 80, 'PST_MSD'
    );

    -- Insert HDB 1
    INSERT INTO program_v1 (
        program, program_type_id, name, description, mode_of_operation, online_type,
        max_session_duration_days, has_multiple_sessions, frequency, default_start_time, default_end_time,
        duration, requires_residence, involves_travel, has_checkin_checkout, requires_payment,
        requires_attendance_all_sessions, allows_minors, allows_proxy_registration, requires_approval,
        registration_level, waitlist_applicable, limited_seats, is_grouped_program, no_of_session,
        max_capacity, total_seats, waitlist_trigger_count, available_seats, filled_seats,
        base_price, gst_percentage, cgst, sgst, igst, tds_percent, gst_number, tds_applicability,
        invoice_sender_name, invoice_sender_pan, invoice_sender_cin, invoice_sender_address,
        helpline_number, email_sender_name, venue_name_in_emails, currency, venue, status, is_active,
        code, banner_image_url, banner_animation_url, logo_url, meta, created_at, updated_at,
        created_by, updated_by, is_approval_required, is_residence_required, is_travel_involved,
        group_id, is_primary_program, primary_program_id, group_display_order,
        registration_starts_at, registration_ends_at, checkin_at, checkout_at, starts_at, ends_at,
        launch_date, checkin_ends_at, checkout_ends_at, child_max_age, elder_min_age, sub_program_type
    ) VALUES (
        '2025-26', (SELECT id FROM program_type_v1 WHERE key = 'PT_HDBMSD'), 'HDB 1', 'A residential spiritual retreat with Mahatria', 'offline', 'NA',
        9, TRUE, 'yearly', '09:00:00', '18:00:00', '9 days', TRUE, TRUE, TRUE, TRUE,
        TRUE, FALSE, FALSE, TRUE, 'program', FALSE, TRUE, FALSE, 0,
        200, 200, 0, 200, 0, 2, 18.00, 9.00, 9.00, 18.00, 10.00,
        '36AACCI7694H1Z5', 'base_only', 'HDB/MSD 2025-26', 'AACCI7694H', 'U74900TN2011PTC083263',
        'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India.',
        '+91 98416 70000', 'HDB/MSD 2025-26', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'INR', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'active', TRUE, 'HDB', 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/MSD.png',
        'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/hdb-banner-animation.webm',
        'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/logo/hdb-logo.svg',
        '{}', NOW(), NOW(), -2, -2, TRUE, TRUE, TRUE, main_group_id, FALSE, main_program_id, 3,
        '2025-08-23T00:00:00.000Z', '2025-06-25T18:29:59.000Z', '2025-12-04T09:30:00.000Z', '2025-12-12T22:30:00.000Z',
        '2025-12-04T03:30:00.000Z', '2025-12-12T11:30:00.000Z', '2025-12-04T03:30:00.000Z',
        '2025-12-04T15:00:00.000Z', '2025-12-13T02:30:00.000Z', 15, 80, 'PST_HDB'
    );

    -- Insert MSD 2
    INSERT INTO program_v1 (
        program, program_type_id, name, description, mode_of_operation, online_type,
        max_session_duration_days, has_multiple_sessions, frequency, default_start_time, default_end_time,
        duration, requires_residence, involves_travel, has_checkin_checkout, requires_payment,
        requires_attendance_all_sessions, allows_minors, allows_proxy_registration, requires_approval,
        registration_level, waitlist_applicable, limited_seats, is_grouped_program, no_of_session,
        max_capacity, total_seats, waitlist_trigger_count, available_seats, filled_seats,
        base_price, gst_percentage, cgst, sgst, igst, tds_percent, gst_number, tds_applicability,
        invoice_sender_name, invoice_sender_pan, invoice_sender_cin, invoice_sender_address,
        helpline_number, email_sender_name, venue_name_in_emails, currency, venue, status, is_active,
        code, banner_image_url, banner_animation_url, logo_url, meta, created_at, updated_at,
        created_by, updated_by, is_approval_required, is_residence_required, is_travel_involved,
        group_id, is_primary_program, primary_program_id, group_display_order,
        registration_starts_at, registration_ends_at, checkin_at, checkout_at, starts_at, ends_at,
        launch_date, checkin_ends_at, checkout_ends_at, child_max_age, elder_min_age, sub_program_type
    ) VALUES (
        '2025-26', (SELECT id FROM program_type_v1 WHERE key = 'PT_HDBMSD'), 'MSD 2', 'A residential spiritual retreat with Mahatria', 'offline', 'NA',
        6, TRUE, 'yearly', '09:00:00', '18:00:00', '6 days', TRUE, TRUE, TRUE, TRUE,
        TRUE, FALSE, FALSE, TRUE, 'program', FALSE, TRUE, FALSE, 0,
        200, 200, 0, 200, 0, 1, 18.00, 9.00, 9.00, 18.00, 10.00,
        '36AACCI7694H1Z5', 'base_only', 'HDB/MSD 2025-26', 'AACCI7694H', 'U74900TN2011PTC083263',
        'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India.',
        '+91 98416 70000', 'HDB/MSD 2025-26', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'INR', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'active', TRUE, 'MSD', 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/MSD.png',
        'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/hdb-banner-animation.webm',
        'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/logo/hdb-logo.svg',
        '{}', NOW(), NOW(), -2, -2, TRUE, TRUE, TRUE, main_group_id, FALSE, main_program_id, 4,
        '2025-08-23T00:00:00.000Z', '2025-06-25T18:29:59.000Z', '2025-12-22T09:30:00.000Z', '2025-12-27T22:30:00.000Z',
        '2025-12-22T03:30:00.000Z', '2025-12-27T11:30:00.000Z', '2025-12-22T03:30:00.000Z',
        '2025-12-22T15:00:00.000Z', '2025-12-28T02:30:00.000Z', 15, 80, 'PST_MSD'
    );

    -- Insert HDB 2
    INSERT INTO program_v1 (
        program, program_type_id, name, description, mode_of_operation, online_type,
        max_session_duration_days, has_multiple_sessions, frequency, default_start_time, default_end_time,
        duration, requires_residence, involves_travel, has_checkin_checkout, requires_payment,
        requires_attendance_all_sessions, allows_minors, allows_proxy_registration, requires_approval,
        registration_level, waitlist_applicable, limited_seats, is_grouped_program, no_of_session,
        max_capacity, total_seats, waitlist_trigger_count, available_seats, filled_seats,
        base_price, gst_percentage, cgst, sgst, igst, tds_percent, gst_number, tds_applicability,
        invoice_sender_name, invoice_sender_pan, invoice_sender_cin, invoice_sender_address,
        helpline_number, email_sender_name, venue_name_in_emails, currency, venue, status, is_active,
        code, banner_image_url, banner_animation_url, logo_url, meta, created_at, updated_at,
        created_by, updated_by, is_approval_required, is_residence_required, is_travel_involved,
        group_id, is_primary_program, primary_program_id, group_display_order,
        registration_starts_at, registration_ends_at, checkin_at, checkout_at, starts_at, ends_at,
        launch_date, checkin_ends_at, checkout_ends_at, child_max_age, elder_min_age, sub_program_type
    ) VALUES (
        '2025-26', (SELECT id FROM program_type_v1 WHERE key = 'PT_HDBMSD'), 'HDB 2', 'A residential spiritual retreat with Mahatria', 'offline', 'NA',
        9, TRUE, 'yearly', '09:00:00', '18:00:00', '9 days', TRUE, TRUE, TRUE, TRUE,
        TRUE, FALSE, FALSE, TRUE, 'program', FALSE, TRUE, FALSE, 0,
        200, 200, 0, 200, 0, 2, 18.00, 9.00, 9.00, 18.00, 10.00,
        '36AACCI7694H1Z5', 'base_only', 'HDB/MSD 2025-26', 'AACCI7694H', 'U74900TN2011PTC083263',
        'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India.',
        '+91 98416 70000', 'HDB/MSD 2025-26', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'INR', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'active', TRUE, 'HDB', 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/MSD.png',
        'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/hdb-banner-animation.webm',
        'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/logo/hdb-logo.svg',
        '{}', NOW(), NOW(), -2, -2, TRUE, TRUE, TRUE, main_group_id, FALSE, main_program_id, 5,
        '2025-08-23T00:00:00.000Z', '2025-06-25T18:29:59.000Z', '2026-01-08T09:30:00.000Z', '2026-01-16T22:30:00.000Z',
        '2026-01-08T03:30:00.000Z', '2026-01-16T11:30:00.000Z', '2026-01-08T03:30:00.000Z',
        '2026-01-08T15:00:00.000Z', '2026-01-17T02:30:00.000Z', 15, 80, 'PST_HDB'
    );

    -- Insert HDB 3
    INSERT INTO program_v1 (
        program, program_type_id, name, description, mode_of_operation, online_type,
        max_session_duration_days, has_multiple_sessions, frequency, default_start_time, default_end_time,
        duration, requires_residence, involves_travel, has_checkin_checkout, requires_payment,
        requires_attendance_all_sessions, allows_minors, allows_proxy_registration, requires_approval,
        registration_level, waitlist_applicable, limited_seats, is_grouped_program, no_of_session,
        max_capacity, total_seats, waitlist_trigger_count, available_seats, filled_seats,
        base_price, gst_percentage, cgst, sgst, igst, tds_percent, gst_number, tds_applicability,
        invoice_sender_name, invoice_sender_pan, invoice_sender_cin, invoice_sender_address,
        helpline_number, email_sender_name, venue_name_in_emails, currency, venue, status, is_active,
        code, banner_image_url, banner_animation_url, logo_url, meta, created_at, updated_at,
        created_by, updated_by, is_approval_required, is_residence_required, is_travel_involved,
        group_id, is_primary_program, primary_program_id, group_display_order,
        registration_starts_at, registration_ends_at, checkin_at, checkout_at, starts_at, ends_at,
        launch_date, checkin_ends_at, checkout_ends_at, child_max_age, elder_min_age, sub_program_type
    ) VALUES (
        '2025-26', (SELECT id FROM program_type_v1 WHERE key = 'PT_HDBMSD'), 'HDB 3', 'A residential spiritual retreat with Mahatria', 'offline', 'NA',
        9, TRUE, 'yearly', '09:00:00', '18:00:00', '9 days', TRUE, TRUE, TRUE, TRUE,
        TRUE, FALSE, FALSE, TRUE, 'program', FALSE, TRUE, FALSE, 0,
        200, 200, 0, 200, 0, 2, 18.00, 9.00, 9.00, 18.00, 10.00,
        '36AACCI7694H1Z5', 'base_only', 'HDB/MSD 2025-26', 'AACCI7694H', 'U74900TN2011PTC083263',
        'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India.',
        '+91 98416 70000', 'HDB/MSD 2025-26', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'INR', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'active', TRUE, 'HDB', 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/MSD.png',
        'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/hdb-banner-animation.webm',
        'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/logo/hdb-logo.svg',
        '{}', NOW(), NOW(), -2, -2, TRUE, TRUE, TRUE, main_group_id, FALSE, main_program_id, 6,
        '2025-08-23T00:00:00.000Z', '2025-06-25T18:29:59.000Z', '2026-01-29T09:30:00.000Z', '2026-02-06T22:30:00.000Z',
        '2026-01-29T03:30:00.000Z', '2026-02-06T11:30:00.000Z', '2026-01-29T03:30:00.000Z',
        '2026-01-29T15:00:00.000Z', '2026-02-07T02:30:00.000Z', 15, 80, 'PST_HDB'
    );

END $$;

-- ================================================================================================
-- 3. INSERT PROGRAM SESSIONS
-- ================================================================================================

-- Insert program session for main program (HDB/MSD 2025-26)
INSERT INTO program_session (
    program_id,
    name,
    description,
    code,
    display_order,
    starts_at,
    ends_at,
    venue,
    mode_of_operation,
    online_type,
    max_session_duration_days,
    has_multiple_sessions,
    frequency,
    default_start_time,
    default_end_time,
    duration,
    requires_residence,
    involves_travel,
    has_checkin_checkout,
    requires_payment,
    requires_attendance_all_sessions,
    allows_minors,
    allows_proxy_registration,
    requires_approval,
    registration_level,
    waitlist_applicable,
    limited_seats,
    is_grouped_program,
    total_seats,
    waitlist_trigger_count,
    available_seats,
    filled_seats,
    max_capacity,
    base_price,
    gst_percentage,
    cgst,
    sgst,
    igst,
    tds_percent,
    gst_number,
    tds_applicability,
    invoice_sender_name,
    invoice_sender_pan,
    invoice_sender_cin,
    invoice_sender_address,
    helpline_number,
    email_sender_name,
    venue_name_in_emails,
    currency,
    status,
    is_active,
    checkin_at,
    checkout_at,
    launch_date,
    checkin_ends_at,
    checkout_ends_at,
    created_at,
    updated_at,
    created_by,
    updated_by
) VALUES (
    (SELECT id FROM program_v1 WHERE name = 'HDB/MSD 2025-26' AND code = 'HDB'),
    'HDB/MSD 2025-26',
    'A residential spiritual retreat with Mahatria',
    'HDB',
    1,
    '2025-11-17T03:30:00.000Z',
    '2026-02-06T11:30:00.000Z',
    'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
    'offline',
    'NA',
    8,
    TRUE,
    'yearly',
    '09:00:00',
    '18:00:00',
    '8 days',
    TRUE,
    TRUE,
    TRUE,
    TRUE,
    TRUE,
    FALSE,
    FALSE,
    TRUE,
    'program',
    FALSE,
    TRUE,
    TRUE,
    1000,
    0,
    1000,
    0,
    1000,
    1,
    18.00,
    9.00,
    9.00,
    18.00,
    10.00,
    '36AACCI7694H1Z5',
    'base_only',
    'HDB/MSD 2025-26',
    'AACCI7694H',
    'U74900TN2011PTC083263',
    'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India.',
    '+91 98416 70000',
    'HDB/MSD 2025-26',
    'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
    'INR',
    'active',
    TRUE,
    '2025-11-17T09:30:00.000Z',
    '2026-02-06T22:30:00.000Z',
    '2025-11-17T03:30:00.000Z',
    '2025-11-17T15:00:00.000Z',
    '2026-02-07T02:30:00.000Z',
    NOW(),
    NOW(),
    -2,
    -2
);

-- Insert program sessions for sub-programs
DO $$
DECLARE
    msd1_program_id INTEGER;
    hdb1_program_id INTEGER;
    msd2_program_id INTEGER;
    hdb2_program_id INTEGER;
    hdb3_program_id INTEGER;
BEGIN
    -- Get program IDs
    SELECT id INTO msd1_program_id FROM program_v1 WHERE name = 'MSD 1';
    SELECT id INTO hdb1_program_id FROM program_v1 WHERE name = 'HDB 1';
    SELECT id INTO msd2_program_id FROM program_v1 WHERE name = 'MSD 2';
    SELECT id INTO hdb2_program_id FROM program_v1 WHERE name = 'HDB 2';
    SELECT id INTO hdb3_program_id FROM program_v1 WHERE name = 'HDB 3';

    -- Insert MSD 1 session
    INSERT INTO program_session (
        program_id, name, description, code, display_order, starts_at, ends_at, venue,
        mode_of_operation, online_type, max_session_duration_days, has_multiple_sessions,
        frequency, default_start_time, default_end_time, duration, requires_residence,
        involves_travel, has_checkin_checkout, requires_payment, requires_attendance_all_sessions,
        allows_minors, allows_proxy_registration, requires_approval, registration_level,
        waitlist_applicable, limited_seats, is_grouped_program, total_seats, waitlist_trigger_count,
        available_seats, filled_seats, max_capacity, base_price, gst_percentage, cgst, sgst, igst,
        tds_percent, gst_number, tds_applicability, invoice_sender_name, invoice_sender_pan,
        invoice_sender_cin, invoice_sender_address, helpline_number, email_sender_name,
        venue_name_in_emails, currency, status, is_active, checkin_at, checkout_at, launch_date,
        checkin_ends_at, checkout_ends_at, created_at, updated_at, created_by, updated_by
    ) VALUES (
        msd1_program_id, 'MSD 1', 'A residential spiritual retreat with Mahatria', 'MSD', 1,
        '2025-11-17T03:30:00.000Z', '2025-11-22T11:30:00.000Z',
        'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'offline', 'NA', 6, TRUE, 'yearly', '09:00:00', '18:00:00', '6 days', TRUE, TRUE, TRUE, TRUE,
        TRUE, FALSE, FALSE, TRUE, 'program', FALSE, TRUE, FALSE, 200, 0, 200, 0, 200, 1, 18.00,
        9.00, 9.00, 18.00, 10.00, '36AACCI7694H1Z5', 'base_only', 'HDB/MSD 2025-26', 'AACCI7694H',
        'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India.',
        '+91 98416 70000', 'HDB/MSD 2025-26', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'INR', 'active', TRUE, '2025-11-17T09:30:00.000Z', '2025-11-22T22:30:00.000Z', '2025-11-17T03:30:00.000Z',
        '2025-11-17T15:00:00.000Z', '2025-11-23T02:30:00.000Z', NOW(), NOW(), -2, -2
    );

    -- Insert HDB 1 session
    INSERT INTO program_session (
        program_id, name, description, code, display_order, starts_at, ends_at, venue,
        mode_of_operation, online_type, max_session_duration_days, has_multiple_sessions,
        frequency, default_start_time, default_end_time, duration, requires_residence,
        involves_travel, has_checkin_checkout, requires_payment, requires_attendance_all_sessions,
        allows_minors, allows_proxy_registration, requires_approval, registration_level,
        waitlist_applicable, limited_seats, is_grouped_program, total_seats, waitlist_trigger_count,
        available_seats, filled_seats, max_capacity, base_price, gst_percentage, cgst, sgst, igst,
        tds_percent, gst_number, tds_applicability, invoice_sender_name, invoice_sender_pan,
        invoice_sender_cin, invoice_sender_address, helpline_number, email_sender_name,
        venue_name_in_emails, currency, status, is_active, checkin_at, checkout_at, launch_date,
        checkin_ends_at, checkout_ends_at, created_at, updated_at, created_by, updated_by
    ) VALUES (
        hdb1_program_id, 'HDB 1', 'A residential spiritual retreat with Mahatria', 'HDB', 1,
        '2025-12-04T03:30:00.000Z', '2025-12-12T11:30:00.000Z',
        'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'offline', 'NA', 9, TRUE, 'yearly', '09:00:00', '18:00:00', '9 days', TRUE, TRUE, TRUE, TRUE,
        TRUE, FALSE, FALSE, TRUE, 'program', FALSE, TRUE, FALSE, 200, 0, 200, 0, 200, 2, 18.00,
        9.00, 9.00, 18.00, 10.00, '36AACCI7694H1Z5', 'base_only', 'HDB/MSD 2025-26', 'AACCI7694H',
        'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India.',
        '+91 98416 70000', 'HDB/MSD 2025-26', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'INR', 'active', TRUE, '2025-12-04T09:30:00.000Z', '2025-12-12T22:30:00.000Z', '2025-12-04T03:30:00.000Z',
        '2025-12-04T15:00:00.000Z', '2025-12-13T02:30:00.000Z', NOW(), NOW(), -2, -2
    );

    -- Insert MSD 2 session
    INSERT INTO program_session (
        program_id, name, description, code, display_order, starts_at, ends_at, venue,
        mode_of_operation, online_type, max_session_duration_days, has_multiple_sessions,
        frequency, default_start_time, default_end_time, duration, requires_residence,
        involves_travel, has_checkin_checkout, requires_payment, requires_attendance_all_sessions,
        allows_minors, allows_proxy_registration, requires_approval, registration_level,
        waitlist_applicable, limited_seats, is_grouped_program, total_seats, waitlist_trigger_count,
        available_seats, filled_seats, max_capacity, base_price, gst_percentage, cgst, sgst, igst,
        tds_percent, gst_number, tds_applicability, invoice_sender_name, invoice_sender_pan,
        invoice_sender_cin, invoice_sender_address, helpline_number, email_sender_name,
        venue_name_in_emails, currency, status, is_active, checkin_at, checkout_at, launch_date,
        checkin_ends_at, checkout_ends_at, created_at, updated_at, created_by, updated_by
    ) VALUES (
        msd2_program_id, 'MSD 2', 'A residential spiritual retreat with Mahatria', 'MSD', 1,
        '2025-12-22T03:30:00.000Z', '2025-12-27T11:30:00.000Z',
        'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'offline', 'NA', 6, TRUE, 'yearly', '09:00:00', '18:00:00', '6 days', TRUE, TRUE, TRUE, TRUE,
        TRUE, FALSE, FALSE, TRUE, 'program', FALSE, TRUE, FALSE, 200, 0, 200, 0, 200, 1, 18.00,
        9.00, 9.00, 18.00, 10.00, '36AACCI7694H1Z5', 'base_only', 'HDB/MSD 2025-26', 'AACCI7694H',
        'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India.',
        '+91 98416 70000', 'HDB/MSD 2025-26', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'INR', 'active', TRUE, '2025-12-22T09:30:00.000Z', '2025-12-27T22:30:00.000Z', '2025-12-22T03:30:00.000Z',
        '2025-12-22T15:00:00.000Z', '2025-12-28T02:30:00.000Z', NOW(), NOW(), -2, -2
    );

    -- Insert HDB 2 session
    INSERT INTO program_session (
        program_id, name, description, code, display_order, starts_at, ends_at, venue,
        mode_of_operation, online_type, max_session_duration_days, has_multiple_sessions,
        frequency, default_start_time, default_end_time, duration, requires_residence,
        involves_travel, has_checkin_checkout, requires_payment, requires_attendance_all_sessions,
        allows_minors, allows_proxy_registration, requires_approval, registration_level,
        waitlist_applicable, limited_seats, is_grouped_program, total_seats, waitlist_trigger_count,
        available_seats, filled_seats, max_capacity, base_price, gst_percentage, cgst, sgst, igst,
        tds_percent, gst_number, tds_applicability, invoice_sender_name, invoice_sender_pan,
        invoice_sender_cin, invoice_sender_address, helpline_number, email_sender_name,
        venue_name_in_emails, currency, status, is_active, checkin_at, checkout_at, launch_date,
        checkin_ends_at, checkout_ends_at, created_at, updated_at, created_by, updated_by
    ) VALUES (
        hdb2_program_id, 'HDB 2', 'A residential spiritual retreat with Mahatria', 'HDB', 1,
        '2026-01-08T03:30:00.000Z', '2026-01-16T11:30:00.000Z',
        'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'offline', 'NA', 9, TRUE, 'yearly', '09:00:00', '18:00:00', '9 days', TRUE, TRUE, TRUE, TRUE,
        TRUE, FALSE, FALSE, TRUE, 'program', FALSE, TRUE, FALSE, 200, 0, 200, 0, 200, 2, 18.00,
        9.00, 9.00, 18.00, 10.00, '36AACCI7694H1Z5', 'base_only', 'HDB/MSD 2025-26', 'AACCI7694H',
        'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India.',
        '+91 98416 70000', 'HDB/MSD 2025-26', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'INR', 'active', TRUE, '2026-01-08T09:30:00.000Z', '2026-01-16T22:30:00.000Z', '2026-01-08T03:30:00.000Z',
        '2026-01-08T15:00:00.000Z', '2026-01-17T02:30:00.000Z', NOW(), NOW(), -2, -2
    );

    -- Insert HDB 3 session
    INSERT INTO program_session (
        program_id, name, description, code, display_order, starts_at, ends_at, venue,
        mode_of_operation, online_type, max_session_duration_days, has_multiple_sessions,
        frequency, default_start_time, default_end_time, duration, requires_residence,
        involves_travel, has_checkin_checkout, requires_payment, requires_attendance_all_sessions,
        allows_minors, allows_proxy_registration, requires_approval, registration_level,
        waitlist_applicable, limited_seats, is_grouped_program, total_seats, waitlist_trigger_count,
        available_seats, filled_seats, max_capacity, base_price, gst_percentage, cgst, sgst, igst,
        tds_percent, gst_number, tds_applicability, invoice_sender_name, invoice_sender_pan,
        invoice_sender_cin, invoice_sender_address, helpline_number, email_sender_name,
        venue_name_in_emails, currency, status, is_active, checkin_at, checkout_at, launch_date,
        checkin_ends_at, checkout_ends_at, created_at, updated_at, created_by, updated_by
    ) VALUES (
        hdb3_program_id, 'HDB 3', 'A residential spiritual retreat with Mahatria', 'HDB', 1,
        '2026-01-29T03:30:00.000Z', '2026-02-06T11:30:00.000Z',
        'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'offline', 'NA', 9, TRUE, 'yearly', '09:00:00', '18:00:00', '9 days', TRUE, TRUE, TRUE, TRUE,
        TRUE, FALSE, FALSE, TRUE, 'program', FALSE, TRUE, FALSE, 200, 0, 200, 0, 200, 2, 18.00,
        9.00, 9.00, 18.00, 10.00, '36AACCI7694H1Z5', 'base_only', 'HDB/MSD 2025-26', 'AACCI7694H',
        'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally, Secunderabad - 500011, Telangana, India.',
        '+91 98416 70000', 'HDB/MSD 2025-26', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
        'INR', 'active', TRUE, '2026-01-29T09:30:00.000Z', '2026-02-06T22:30:00.000Z', '2026-01-29T03:30:00.000Z',
        '2026-01-29T15:00:00.000Z', '2026-02-07T02:30:00.000Z', NOW(), NOW(), -2, -2
    );

END $$;

-- ================================================================================================
-- 4. VERIFICATION QUERIES (COMMENTED)
-- ================================================================================================

-- Check inserted programs
-- SELECT id, name, code, group_display_order, is_primary_program, total_seats, base_price, 
--        starts_at, ends_at, checkin_at, checkout_at 
-- FROM program_v1 
-- WHERE name LIKE '%HDB/MSD 2025-26%' OR name LIKE '%MSD%' OR name LIKE '%HDB%'
-- ORDER BY group_display_order;

-- Check program grouping
-- SELECT p.id, p.name, p.code, p.group_id, p.is_primary_program, p.primary_program_id, p.group_display_order
-- FROM program_v1 p
-- WHERE p.group_id = (SELECT group_id FROM program_v1 WHERE name = 'HDB/MSD 2025-26' AND code = 'HDB')
-- ORDER BY p.group_display_order;