-- ================================================================================================
-- CREATE EMPTY USER PROFILE EXTENSIONS FOR EXISTING USERS
-- This script creates empty user_profile_extension records for users who don't have them
-- ================================================================================================

-- First, let's check how many users are missing profile extensions
SELECT 
    COUNT(*) as users_without_profile_extension
FROM users u
WHERE NOT EXISTS (
    SELECT 1 
    FROM user_profile_extension upe 
    WHERE upe.user_id = u.id
);

-- Create empty user profile extension records for users who don't have them
INSERT INTO user_profile_extension (
    user_id,
    created_at,
    updated_at,
    created_by,
    updated_by
)
SELECT 
    u.id AS user_id,
    NOW() AS created_at,
    NOW() AS updated_at,
    u.id AS created_by,  -- Use the user's own ID as creator
    u.id AS updated_by   -- Use the user's own ID as updater
FROM users u
WHERE NOT EXISTS (
    SELECT 1 
    FROM user_profile_extension upe 
    WHERE upe.user_id = u.id
);  -- Only for active users

-- Verify the insertion
SELECT 
    COUNT(*) as total_profile_extensions_after_insert
FROM user_profile_extension;