-- feature flag master data
INSERT INTO public.feature_flag (id, feature_key, label, description, flag, status, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (1, 'showInfiniminutePrayer', 'Show Infiniminute Prayer', 'Toggle Infiniminute Prayer feature', false, 'active', '2025-07-18 14:45:09.169932+05:30', '2025-07-18 14:45:09.169932+05:30', NULL, -2, -2);
INSERT INTO public.feature_flag (id, feature_key, label, description, flag, status, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (2, 'showInfinipath', 'Show Infinipath', 'Toggle Infinipath feature', false, 'active', '2025-07-18 14:45:09.169932+05:30', '2025-07-18 14:45:09.169932+05:30', NULL, -2, -2);

-- User master users insert
INSERT INTO public.users (id, phone_number, full_name, role, "createdAt", "updatedAt", created_at, updated_at, is_infiminute, is_infimessages, user_approval_status, first_name, last_name, status_updated_at, is_infipath, email, is_infimessage_user_active, is_infipath_user_active, name_audio, is_infiminute_user_active, profile_url, address, country_code, associated_since, gender, dob, other_address, firebase_id_ext, acknowledgement_date, terms_and_conditions, alternate_country_code, alternate_phone_number, alternate_email, encrypted_phone_number, masked_phone_number, encrypted_email, is_system_user, is_ai_user, user_type, legal_full_name) VALUES (-2, NULL, 'System User', 'admin', NULL, '2025-05-27 22:06:42.200158+05:30', '2025-05-27 22:06:42.200158+05:30', '2025-05-27 22:06:42.200158+05:30', NULL, NULL, 'accepted', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, true, NULL, NULL, NULL, NULL, NULL, NULL, true, false, 'System', 'System User');
INSERT INTO public.users (id, phone_number, full_name, role, "createdAt", "updatedAt", created_at, updated_at, is_infiminute, is_infimessages, user_approval_status, first_name, last_name, status_updated_at, is_infipath, email, is_infimessage_user_active, is_infipath_user_active, name_audio, is_infiminute_user_active, profile_url, address, country_code, associated_since, gender, dob, other_address, firebase_id_ext, acknowledgement_date, terms_and_conditions, alternate_country_code, alternate_phone_number, alternate_email, encrypted_phone_number, masked_phone_number, encrypted_email, is_system_user, is_ai_user, user_type, legal_full_name) VALUES (-3, NULL, 'AI Assistant', 'admin', NULL, '2025-05-27 22:06:54.376528+05:30', '2025-05-27 22:06:54.376528+05:30', '2025-05-27 22:06:54.376528+05:30', NULL, NULL, 'accepted', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, true, NULL, NULL, NULL, NULL, NULL, NULL, false, true, 'AI', 'AI Assistant');


-- form section master data
-- INSERT INTO public.hdb_form_section (
--     id, name, description, created_at, updated_at, deleted_at,
--     created_by, updated_by, display_order, key
-- ) VALUES
-- (1, 'Basic Details', 'Section for basic user details', now(), NULL, NULL, -2, -2, 1, 'FS_BASICDETAILS'),
-- (2, 'Payment & Invoice', 'Section for invoice information', now(), NULL, NULL, -2, -2, 2, 'FS_PAYMENTINVOICE'),
-- (3, 'Travel Plan & Goodies', 'Section for travel plan details', now(), NULL, NULL, -2, -2, 3, 'FS_TRAVELPLAN'),
-- (4, 'Mahatria''s Questions', 'Section to display seeker filled questions to mahatria', now(), NULL, NULL, -2, -2, 4, 'FS_MAHATRIAQUESTIONS');

INSERT INTO public.hdb_form_section (id, name, description, created_at, updated_at, deleted_at, created_by, updated_by, display_order, key) VALUES (1, 'Basic Details', 'Section for basic user details', '2025-05-28 12:59:51.789449+05:30', '2025-06-14 12:27:19.255535+05:30', NULL, -2, -2, 1, 'FS_BASICDETAILS');
INSERT INTO public.hdb_form_section (id, name, description, created_at, updated_at, deleted_at, created_by, updated_by, display_order, key) VALUES (3, 'Travel Plan & Goodies', 'Section for travel plan details', '2025-05-28 12:59:51.789449+05:30', '2025-06-14 12:27:19.49327+05:30', NULL, -2, -2, 3, 'FS_TRAVELPLAN');
INSERT INTO public.hdb_form_section (id, name, description, created_at, updated_at, deleted_at, created_by, updated_by, display_order, key) VALUES (2, 'Payment & Invoice', 'Section for invoice information', '2025-05-28 12:59:51.789449+05:30', '2025-06-14 12:27:19.375288+05:30', NULL, -2, -2, 2, 'FS_PAYMENTINVOICE');
INSERT INTO public.hdb_form_section (id, name, description, created_at, updated_at, deleted_at, created_by, updated_by, display_order, key) VALUES (4, 'Mahatria''s Questions', 'Section to display seeker filled questions to mahatria', '2025-05-28 12:59:51.789449+05:30', '2025-05-28 12:59:51.789449+05:30', NULL, -2, -2, 4, 'FS_MAHATRIAQUESTIONS');


-- -- program type master data
-- INSERT INTO public.program_type_v1 VALUES (2, 'offline', 'HDB/MSD', 'A residential spiritual retreat with Mahatria', '2025-06-11 21:31:28.575211+05:30', '2025-06-11 21:31:28.575211+05:30', NULL, 'NA', 6, true, 'yearly', '09:00:00', '18:00:00', '540', true, true, true, true, true, false, false, true, 'program', true, -2, -2, 5, false, 1000, NULL, 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.', true, true, 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/logo/hdb-logo.svg', 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/MSD.png', 'PT_HDBMSD', 18.00, 9.00, 9.00, 18.00, 10.00, '36AACCI7694H1Z5', 'base_only', 'infinitheism spiritual foundation private limited', 'AACCI7694H', 'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally,
-- Secunderabad - 500011, Telangana, India', '+91 98416 70000', 'hdb@infinitheism.com', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.', true);
-- INSERT INTO public.program_type_v1 VALUES (3, 'offline', 'Entrainment', 'A residential spiritual retreat with Mahatria', '2025-06-11 21:31:28.575211+05:30', '2025-06-11 21:31:28.575211+05:30', NULL, 'NA', 4, false, 'yearly', '20:00:00', '21:00:00', '60', true, true, true, true, true, true, true, false, 'program', true, -2, -2, 0, true, 1200, NULL, 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.', true, false, 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/logo/entrainment-logo.svg', 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/Entrainment.png', 'PT_ENTRAINMENT', 18.00, 9.00, 9.00, 18.00, 10.00, '36AACCI7694H1Z5', 'base_only', 'infinitheism spiritual foundation private limited', 'AACCI7694H', 'U74900TN2011PTC083263', 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally,
-- Secunderabad - 500011, Telangana, India', '+91 98416 70000', 'hdb@infinitheism.com', 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.', true);
INSERT INTO public.program_type_v1 (
    id, mode_of_operation, name, description, created_at, updated_at, deleted_at,
    online_type, max_session_duration_days, has_multiple_sessions, frequency,
    default_start_time, default_end_time, default_duration, requires_residence,
    involves_travel, has_checkin_checkout, requires_payment, requires_attendance_all_sessions,
    allows_minors, allows_proxy_registration, requires_approval, registration_level,
    is_active, created_by, updated_by, no_of_session, waitlist_applicable, max_capacity,
    meta, venue, limited_seats, is_grouped_program, logo_url, banner_url, key, igst,
    cgst, sgst, gst_percentage, tds_percent, gst_number, tds_applicability,
    invoice_sender_name, invoice_sender_pan, invoice_sender_cin, invoice_sender_address,
    helpline_number, email_sender_name, venue_name_in_emails, is_special_program
) VALUES
-- HDB/MSD
(2, 'offline', 'HDB/MSD', 'A residential spiritual retreat with Mahatria',
 '2025-06-11T21:31:28.575211+05:30', '2025-06-11T21:31:28.575211+05:30', NULL,
 'NA', 6, true, 'yearly', '09:00:00', '18:00:00', '540', true, true, true, true, true,
 false, false, true, 'program', true, -2, -2, 5, false, 1000, NULL,
 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
 true, true,
 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/logo/hdb-logo.svg',
 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/MSD.png',
 'PT_HDBMSD', 18.00, 9.00, 9.00, 18.00, 10.00, '36AACCI7694H1Z5', 'base_only',
 'infinitheism spiritual foundation private limited', 'AACCI7694H', 'U74900TN2011PTC083263',
 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally,
Secunderabad - 500011, Telangana, India',
 '+91 98416 70000', 'hdb@infinitheism.com',
 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
 true),

-- Entrainment
(3, 'offline', 'Entrainment', 'A residential spiritual retreat with Mahatria',
 '2025-06-11T21:31:28.575211+05:30', '2025-06-11T21:31:28.575211+05:30', NULL,
 'NA', 4, false, 'yearly', '20:00:00', '21:00:00', '60', true, true, true, true, true,
 true, true, false, 'program', true, -2, -2, 0, true, 1200, NULL,
 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
 true, false,
 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/logo/entrainment-logo.svg',
 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/Entrainment.png',
 'PT_ENTRAINMENT', 18.00, 9.00, 9.00, 18.00, 10.00, '36AACCI7694H1Z5', 'base_only',
 'infinitheism spiritual foundation private limited', 'AACCI7694H', 'U74900TN2011PTC083263',
 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally,
Secunderabad - 500011, Telangana, India',
 '+91 98416 70000', 'hdb@infinitheism.com',
 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
 true);

 -- update existing program type infinipath
 UPDATE public.program_type_v1
SET
    updated_at = '2025-06-11T21:31:28.575211+05:30',
    deleted_at = NULL,
    mode_of_operation = 'online',
    online_type = 'webinar',
    max_session_duration_days = 1,
    has_multiple_sessions = true,
    frequency = 'weekly',
    default_start_time = '10:00:00',
    default_end_time = '11:15:00',
    default_duration = '75',
    requires_residence = false,
    involves_travel = false,
    has_checkin_checkout = false,
    requires_payment = false,
    requires_attendance_all_sessions = false,
    allows_minors = true,
    allows_proxy_registration = false,
    requires_approval = false,
    registration_level = 'session',
    is_active = true,
    created_by = -2,
    updated_by = -2,
    no_of_session = 0,
    waitlist_applicable = false,
    max_capacity = 1000,
    meta = NULL,
    venue = 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
    limited_seats = true,
    is_grouped_program = true,
    logo_url = 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/logo/infinipath-logo.svg',
    banner_url = 'https://infinitheism-serverless.s3.ap-south-1.amazonaws.com/static-images/banner/infinipath.png',
    igst = 18.00,
    cgst = 9.00,
    sgst = 9.00,
    gst_percentage = 18.00,
    tds_percent = 10.00,
    gst_number = '36AACCI7694H1Z5',
    tds_applicability = 'base_only',
    invoice_sender_name = 'infinitheism spiritual foundation private limited',
    invoice_sender_pan = 'AACCI7694H',
    invoice_sender_cin = 'U74900TN2011PTC083263',
    invoice_sender_address = 'No.8-5-248/1, Syndicate Bank Colony, Old Bowenpally,
Secunderabad - 500011, Telangana, India',
    helpline_number = '+91 98416 70000',
    email_sender_name = 'hdb@infinitheism.com',
    venue_name_in_emails = 'Leonia Holistic Destination, Bommarasipet, Shamirpet Mandal, Medchal-Malkajgiri District, Hyderabad - 500078.',
    is_special_program = false
WHERE id = 1 AND key = 'PT_INFINIPATH';



-- rating type master data
INSERT INTO public.hdb_program_registration_rm_rating_type (
    id, rating_key, name, created_at, updated_at, created_by, updated_by
) VALUES
(1, 'passion', 'Passion', now(), NULL, NULL, NULL),
(2, 'growth', 'Growth', now(), NULL, NULL, NULL),
(3, 'infinitheist', 'infinitheist', now(), NULL, NULL, NULL),
(4, 'continuity', 'Continuity', now(), NULL, NULL, NULL);


INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (1, 'BANK_NAME', 'Bank Name', 'BANK_OF_BARODA', 'Bank of Baroda', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (2, 'BANK_NAME', 'Bank Name', 'BANK_OF_INDIA', 'Bank of India', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (3, 'BANK_NAME', 'Bank Name', 'BANK_OF_MAHARASHTRA', 'Bank of Maharashtra', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (4, 'BANK_NAME', 'Bank Name', 'CANARA_BANK', 'Canara Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (5, 'BANK_NAME', 'Bank Name', 'CENTRAL_BANK_OF_INDIA', 'Central Bank of India', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (6, 'BANK_NAME', 'Bank Name', 'INDIAN_BANK', 'Indian Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (7, 'BANK_NAME', 'Bank Name', 'INDIAN_OVERSEAS_BANK', 'Indian Overseas Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (8, 'BANK_NAME', 'Bank Name', 'PUNJAB_AND_SIND_BANK', 'Punjab and Sind Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (9, 'BANK_NAME', 'Bank Name', 'PUNJAB_NATIONAL_BANK', 'Punjab National Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (10, 'BANK_NAME', 'Bank Name', 'STATE_BANK_OF_INDIA', 'State Bank of India', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (11, 'BANK_NAME', 'Bank Name', 'UCO_BANK', 'UCO Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (12, 'BANK_NAME', 'Bank Name', 'UNION_BANK_OF_INDIA', 'Union Bank of India', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (13, 'BANK_NAME', 'Bank Name', 'AXIS_BANK', 'Axis Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (14, 'BANK_NAME', 'Bank Name', 'BANDHAN_BANK', 'Bandhan Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (15, 'BANK_NAME', 'Bank Name', 'CSB_BANK', 'CSB Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (16, 'BANK_NAME', 'Bank Name', 'CITY_UNION_BANK', 'City Union Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (17, 'BANK_NAME', 'Bank Name', 'DCB_BANK', 'DCB Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (18, 'BANK_NAME', 'Bank Name', 'DHANLAXMI_BANK', 'Dhanlaxmi Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (19, 'BANK_NAME', 'Bank Name', 'FEDERAL_BANK', 'Federal Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (20, 'BANK_NAME', 'Bank Name', 'HDFC_BANK', 'HDFC Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (21, 'BANK_NAME', 'Bank Name', 'ICICI_BANK', 'ICICI Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (22, 'BANK_NAME', 'Bank Name', 'IDBI_BANK', 'IDBI Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (23, 'BANK_NAME', 'Bank Name', 'IDFC_FIRST_BANK', 'IDFC First Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (24, 'BANK_NAME', 'Bank Name', 'INDUSIND_BANK', 'IndusInd Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (25, 'BANK_NAME', 'Bank Name', 'KARNATAKA_BANK', 'Karnataka Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (26, 'BANK_NAME', 'Bank Name', 'KARUR_VYSYA_BANK', 'Karur Vysya Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (27, 'BANK_NAME', 'Bank Name', 'KOTAK_MAHINDRA_BANK', 'Kotak Mahindra Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (28, 'BANK_NAME', 'Bank Name', 'NAINITAL_BANK', 'Nainital Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (29, 'BANK_NAME', 'Bank Name', 'RBL_BANK', 'RBL Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (30, 'BANK_NAME', 'Bank Name', 'SOUTH_INDIAN_BANK', 'South Indian Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (31, 'BANK_NAME', 'Bank Name', 'TAMILNAD_MERCANTILE_BANK', 'Tamilnad Mercantile Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (32, 'BANK_NAME', 'Bank Name', 'YES_BANK', 'Yes Bank', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (33, 'BANK_NAME', 'Bank Name', 'JAMMU_AND_KASHMIR_BANK_LTD', 'Jammu & Kashmir Bank Ltd', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (34, 'BANK_NAME', 'Bank Name', 'OTHER', 'Other', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (35, 'CITY_NAME', 'City', 'HYDERABAD', 'Hyderabad', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (36, 'CITY_NAME', 'City', 'MUMBAI', 'Mumbai', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (37, 'CITY_NAME', 'City', 'DELHI', 'Delhi', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (38, 'CITY_NAME', 'City', 'BANGALORE', 'Bangalore', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (39, 'CITY_NAME', 'City', 'KOLKATA', 'Kolkata', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (40, 'CITY_NAME', 'City', 'PUNE', 'Pune', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (41, 'CITY_NAME', 'City', 'AHMEDABAD', 'Ahmedabad', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (42, 'CITY_NAME', 'City', 'JAIPUR', 'Jaipur', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (43, 'CITY_NAME', 'City', 'SURAT', 'Surat', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (44, 'CITY_NAME', 'City', 'LUCKNOW', 'Lucknow', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (45, 'CITY_NAME', 'City', 'KANPUR', 'Kanpur', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (46, 'CITY_NAME', 'City', 'NAGPUR', 'Nagpur', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (47, 'CITY_NAME', 'City', 'PATNA', 'Patna', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (48, 'CITY_NAME', 'City', 'INDORE', 'Indore', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (49, 'CITY_NAME', 'City', 'BHOPAL', 'Bhopal', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (50, 'CITY_NAME', 'City', 'VADODARA', 'Vadodara', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (51, 'CITY_NAME', 'City', 'LUDHIANA', 'Ludhiana', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (52, 'CITY_NAME', 'City', 'AGRA', 'Agra', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (53, 'CITY_NAME', 'City', 'VARANASI', 'Varanasi', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (54, 'CITY_NAME', 'City', 'AMRITSAR', 'Amritsar', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (55, 'CITY_NAME', 'City', 'COIMBATORE', 'Coimbatore', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (56, 'CITY_NAME', 'City', 'THIRUVANANTHAPURAM', 'Thiruvananthapuram', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (57, 'CITY_NAME', 'City', 'GUWAHATI', 'Guwahati', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (58, 'CITY_NAME', 'City', 'RANCHI', 'Ranchi', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (59, 'CITY_NAME', 'City', 'OTHER', 'Other', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (60, 'GENDER', 'Gender', 'OTHER', 'Other', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (61, 'GENDER', 'Gender', 'MALE', 'Male', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (62, 'GENDER', 'Gender', 'FEMALE', 'Female', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (63, 'GENDER', 'Gender', 'PREFER_NOT_TO_SAY', 'Prefer not to say', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (64, 'PAYMENT_MODE', 'Payment mode', 'ONLINE', 'Online', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (65, 'PAYMENT_MODE', 'Payment mode', 'OFFLINE', 'Offline', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (66, 'PAYMENT_MODE', 'Payment mode', 'CHEQUE', 'Cheque', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (67, 'PAYMENT_MODE', 'Payment mode', 'CARD_SWIPE', 'Card swipe', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (68, 'PAYMENT_MODE', 'Payment mode', 'CASH', 'Cash', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (69, 'PAYMENT_MODE', 'Payment mode', 'ONLINE_RAZORPAY', 'Online (Through Razorpay)', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (70, 'PAYMENT_MODE', 'Payment mode', 'DIRECT_BANK_TRANSFER', 'Direct bank transfer (NEFT/RTGS)', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (71, 'TSHIRT_SIZE', 'Tshirt size', 'XS', 'XS', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (72, 'TSHIRT_SIZE', 'Tshirt size', 'S', 'S', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (73, 'TSHIRT_SIZE', 'Tshirt size', 'M', 'M', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (74, 'TSHIRT_SIZE', 'Tshirt size', 'L', 'L', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (75, 'TSHIRT_SIZE', 'Tshirt size', 'XL', 'XL', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (76, 'TSHIRT_SIZE', 'Tshirt size', 'XXL', 'XXL', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (77, 'TSHIRT_SIZE', 'Tshirt size', 'XXXL', 'XXXL', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (78, 'TRAVEL_PLAN', 'Travel Plan', 'FLIGHT', 'Flight', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (79, 'TRAVEL_PLAN', 'Travel Plan', 'OWN_TRANSPORT', 'Own transport', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (80, 'TRAVEL_PLAN', 'Travel Plan', 'CITY_DROP', 'City drop', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (81, 'TRAVEL_PLAN', 'Travel Plan', 'CITY_PICK_UP', 'City pick up', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (82, 'ID_TYPE', 'Id type', 'PASSPORT', 'Passport', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (83, 'ID_TYPE', 'Id type', 'AADHAR', 'Aadhar', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (84, 'ID_TYPE', 'Id type', 'DRIVING_LICENSE', 'Driving license', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (85, 'ID_TYPE', 'Id type', 'VOTER_ID', 'Voter id', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (86, 'ID_TYPE', 'Id type', 'PAN_CARD', 'Pan card', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (87, 'AIRLINE', 'Airline', 'EK', 'Emirates', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (88, 'AIRLINE', 'Airline', 'EY', 'Etihad Airways', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (89, 'AIRLINE', 'Airline', 'QR', 'Qatar Airways', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (90, 'AIRLINE', 'Airline', 'SQ', 'Singapore Air', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (91, 'AIRLINE', 'Airline', 'I5', 'Air Asia', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (92, 'AIRLINE', 'Airline', 'AI', 'Air India', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (93, 'AIRLINE', 'Airline', 'G8', 'Go First', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (94, 'AIRLINE', 'Airline', '6E', 'IndiGo', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (95, 'AIRLINE', 'Airline', 'SG', 'SpiceJet', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (96, 'AIRLINE', 'Airline', 'UK', 'Vistara', 'active');
INSERT INTO public.lookup_data (id, lookup_category, lookup_category_name, lookup_key, lookup_label, lookup_status) VALUES (97, 'AIRLINE', 'Airline', 'OTHER', 'Other', 'active');



INSERT INTO public.user_role (id, name, created_at, updated_at, role_key) VALUES (1, 'viewer', '2025-06-01 18:53:50.506276+05:30', '2025-06-01 18:53:50.506276+05:30', 'ROLE_VIEWER');
INSERT INTO public.user_role (id, name, created_at, updated_at, role_key) VALUES (2, 'admin', '2025-06-01 18:53:50.506276+05:30', '2025-06-01 18:53:50.506276+05:30', 'ROLE_ADMIN');
INSERT INTO public.user_role (id, name, created_at, updated_at, role_key) VALUES (3, 'mahatria', '2025-06-01 18:53:50.506276+05:30', '2025-06-01 18:53:50.506276+05:30', 'ROLE_MAHATRIA');
INSERT INTO public.user_role (id, name, created_at, updated_at, role_key) VALUES (5, 'finance_manager', '2025-06-01 18:53:50.506276+05:30', '2025-06-01 18:53:50.506276+05:30', 'ROLE_FINANCE_MANAGER');
INSERT INTO public.user_role (id, name, created_at, updated_at, role_key) VALUES (6, 'relational_manager', '2025-06-01 18:53:50.506276+05:30', '2025-06-01 18:53:50.506276+05:30', 'ROLE_RELATIONAL_MANAGER');
INSERT INTO public.user_role (id, name, created_at, updated_at, role_key) VALUES (7, 'shoba', '2025-06-01 18:53:50.506276+05:30', '2025-06-01 18:53:50.506276+05:30', 'ROLE_SHOBA');
INSERT INTO public.user_role (id, name, created_at, updated_at, role_key) VALUES (8, 'operational_manger', '2025-06-01 18:53:50.506276+05:30', '2025-06-01 18:53:50.506276+05:30', 'ROLE_OPERATIONAL_MANAGER');


INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (1, 'Full name', '{"maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "minCharacter": 2, "maxCharacters": 30, "conditionalFields": [], "validationPattern": "^[a-zA-Z\\s\\.]+$"}', 'published', 'text', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 1, 'hdb_program_registration.full_name', 'name');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (2, 'Gender', '{"maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "minCharacter": null, "maxCharacters": null, "conditionalFields": null, "validationPattern": null}', 'published', 'radio', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 1, 'hdb_program_registration.gender', 'gender');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (3, 'Mobile number', '{"maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "minCharacter": 10, "maxCharacters": 15, "conditionalFields": [], "validationPattern": "^[0-9+\\-\\s\\(\\)]+$"}', 'published', 'tel', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 1, 'hdb_program_registration.mobile_number', 'mobileNumber');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (4, 'Email address', '{"maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "minCharacter": 5, "maxCharacters": 100, "conditionalFields": [], "validationPattern": "^[^\\s@]+@[^\\s@]+\\.[^\\s@]+$"}', 'published', 'email', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 1, 'hdb_program_registration.email_address', 'email');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (5, 'Date of birth', '{"maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "minCharacter": null, "maxCharacters": null, "pastValidation": {"unit": "year", "enabled": true, "maxValue": 100, "minValue": 13}, "futureValidation": {"unit": "days", "enabled": false, "maxValue": null, "minValue": null}, "conditionalFields": [], "validationPattern": null, "dateTypeValidation": "dynamic"}', 'published', 'date', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 1, 'hdb_program_registration.dob', 'dob');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (6, 'City', '{"maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "minCharacter": 2, "maxCharacters": 50, "conditionalFields": [], "validationPattern": "^[a-zA-Z\\s]+$"}', 'published', 'select', '2025-06-02 16:56:24.759844+05:30', '2025-06-02 16:56:24.759844+05:30', NULL, -2, -2, 1, 'hdb_program_registration.city', 'city');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (7, 'Other city', '{"dependsOn": [{"value": "Other", "questionId": 6}], "isRequired": true}', 'published', 'text', '2025-06-26 21:58:29.790381+05:30', '2025-06-26 21:58:29.790381+05:30', NULL, -2, -2, 1, NULL, 'otherCityName');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (8, 'Upload profile picture', '{"filetype": "profile", "isRequired": true}', 'published', 'file', '2025-06-20 13:00:15.487604+05:30', '2025-06-20 13:00:15.487604+05:30', NULL, -2, -2, 1, 'hdb_program_registration.user_profile_url', 'profileUrl');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (9, 'infinitheism contact', '{"type": "select", "endPoint": "user?filters=%7B%22role%22%3A%20%226%22%7D&limit=1000", "maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "minCharacter": null, "maxCharacters": null, "conditionalFields": [], "validationPattern": null}', 'published', 'apicall', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 1, 'hdb_program_registration.rm_contact', 'rmContact');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (10, 'Other infinitheism contact', '{"dependsOn": [{"value": 9568, "questionId": 9}], "isRequired": true}', 'published', 'text', '2025-07-03 20:45:55.621298+05:30', '2025-07-03 20:45:55.621298+05:30', NULL, -2, -2, 1, NULL, 'otherInfinitheismContact');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (11, 'Since when have you been associated with infinitheism?', '{"maxYear": "current", "isRequired": true, "yearOffset": 1995, "maxYearOffset": 0}', 'published', 'year', '2025-06-21 12:44:54.163106+05:30', '2025-06-21 12:44:54.163106+05:30', NULL, -2, -2, 1, NULL, 'QK_HDB_ASSOCIATION_SINCE');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (12, 'How many HDB/MSD have you done?', '{"maxValue": 35, "minValue": 0, "isRequired": true}', 'published', 'number', '2025-06-21 12:45:31.655254+05:30', '2025-06-21 12:45:31.655254+05:30', NULL, -2, -2, 1, 'hdb_program_registration.no_of_hdbs', 'no_of_hdbs');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (13, 'When was your last HDB/MSD?', '{"maxYear": "current", "isRequired": false, "yearOffset": 1995, "maxYearOffset": -1}', 'published', 'yearRange', '2025-06-21 12:46:55.087762+05:30', '2025-06-21 12:46:55.087762+05:30', NULL, -2, -2, 1, NULL, 'QK_LAST_HDB');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (14, 'Preferred roommate''s name', '{"maxValue": null, "minValue": null, "dependsOn": [], "isRequired": false, "minCharacter": 2, "maxCharacters": 30, "conditionalFields": [], "validationPattern": "^[a-zA-Z\\s]+$"}', 'published', 'text', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 1, 'hdb_program_registration.preferred_room_mate', 'roommate');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (15, 'Billing name (pro-forma)', '{"maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "minCharacter": 3, "maxCharacters": 99, "conditionalFields": [], "validationPattern": "^[a-zA-Z\\s./-]+$"}', 'published', 'text', '2025-06-20 17:24:19.824818+05:30', '2025-06-20 17:24:19.824818+05:30', NULL, -2, -2, 1, 'hdb_program_registration.pro_forma_invoice_name', 'pro_forma_invoice_name');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (16, 'Billing address (pro-forma)', '{"maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "minCharacter": 10, "maxCharacters": 99, "conditionalFields": [], "validationPattern": null}', 'published', 'Address', '2025-06-20 17:25:21.030239+05:30', '2025-06-20 17:25:21.030239+05:30', NULL, -2, -2, 1, 'hdb_program_registration.pro_forma_invoice_address', 'proFormaBillingAddress');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (17, 'Preference', '{"isRequired": true, "allowMahatriaChoice": true}', 'published', 'draganddrop', '2025-06-03 01:03:57.886505+05:30', '2025-06-03 01:03:57.886505+05:30', NULL, -2, -2, 1, 'hdb_preference', 'preference');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (18, 'Upload video', '{"filetype": "video", "isRequired": true}', 'published', 'file', '2025-06-20 13:01:52.562067+05:30', '2025-06-20 13:01:52.562067+05:30', NULL, -2, -2, 1, 'hdb_program_registration.user_video_url', 'videoUrl');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (19, 'Use existing details as per pro-forma invoice', '{"isRequired": true}', 'published', 'radio', '2025-06-20 17:18:33.801451+05:30', '2025-06-20 17:18:33.801451+05:30', NULL, -2, -2, 2, NULL, 'existingProformaInvoice');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (20, 'Name for invoice', '{"prefill": {"prefillIf": [{"value": "yes", "questionId": 19}], "prefillFrom": 15, "prefillType": "fieldDependent"}, "maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "minCharacter": 3, "maxCharacters": 99, "conditionalFields": [], "validationPattern": "^[a-zA-Z\\s./-]+$"}', 'published', 'text', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 2, 'hdb_registration_invoice_detail.invoice_name', 'invoiceName');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (21, 'Email address for invoice', '{"prefill": {"prefillType": "fieldDependent"}, "maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "maxCharacters": 100, "conditionalFields": [], "validationPattern": "^[^\\s@]+@[^\\s@]+\\.[^\\s@]+$"}', 'published', 'email', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 2, 'hdb_registration_invoice_detail.invoice_email', 'invoiceEmail');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (22, 'Registered under Indian GST', '{"maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "showDialog": {"type": "popup", "isShow": "no", "imageName": null, "contentType": "text", "dialogueContent": "If you do not provide your GSTIN, this transaction will be filed under ‘unregistered’ category in our GST return."}, "minCharacter": null, "maxCharacters": null, "conditionalFields": [], "validationPattern": null}', 'published', 'radio', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 2, 'hdb_registration_invoice_detail.is_gst_registered', 'isGstRegistered');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (23, 'Address for invoice', '{"prefill": {"prefillIf": [{"value": "yes", "questionId": 19}], "prefillFrom": 16}, "maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "minCharacter": 10, "maxCharacters": 99, "conditionalFields": [], "validationPattern": null}', 'published', 'textarea', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 2, 'hdb_registration_invoice_detail.invoice_address', 'invoiceAddress');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (24, 'PIN code', '{"dependsOn": [{"value": "yes", "questionId": 22}], "isRequired": true}', 'published', 'text', '2025-06-14 14:34:06.523245+05:30', '2025-06-14 14:34:06.523245+05:30', NULL, -2, -2, 2, 'hdb_registration_invoice_detail.zip', 'zip');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (25, 'GST No. for invoice', '{"dependsOn": [{"value": "yes", "questionId": 22}], "isRequired": true}', 'published', 'text', '2025-06-14 14:37:02.122783+05:30', '2025-06-14 14:37:02.122783+05:30', NULL, -2, -2, 2, 'hdb_registration_invoice_detail.gst_number', 'gstNumber');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (26, 'TDS', '{"dependsOn": []}', 'published', 'number', '2025-06-14 14:44:13.46664+05:30', '2025-06-14 14:44:13.46664+05:30', NULL, -2, -2, 2, 'hdb_registration_invoice_detail.tds_amount', 'tdsAmount');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (27, 'TAN number', '{"maxValue": null, "minValue": null, "dependsOn": [{"value": "notNull", "questionId": 26}], "isRequired": true, "minCharacter": 10, "maxCharacters": 10, "conditionalFields": [], "validationPattern": "[A-Za-z]{4}[0-9]{5}[A-Za-z]{1}$"}', 'published', 'text', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 2, 'hdb_registration_invoice_detail.tan_number', 'tanNumber');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (28, 'Payment method', '{"maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "showDialog": {"type": "card", "isShow": "Online (Through Razorpay)", "imageName": null, "contentType": "text", "dialogueContent": "You will be redirected to Razorpay payment gateway upon clicking ‘submit’", "dialogueContentType": "static"}, "minCharacter": null, "maxCharacters": null, "conditionalFields": [], "showDialogMessage": [{"type": "card", "isShow": "Online (Through Razorpay)", "imageName": null, "contentType": "text", "dialogueContent": null}], "validationPattern": null}', 'published', 'radio', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 2, 'hdb_registration_payment_detail.payment_mode', 'paymentMode');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (29, 'Amount', '{"minValue": 1, "dependsOn": [{"value": "Cheque", "questionId": 28}, {"value": "Direct bank transfer (NEFT/RTGS)", "questionId": 28}, {"value": "Card swipe", "questionId": 28}, {"value": "Cash", "questionId": 28}], "isDisable": true, "isRequired": true, "minCharacter": 1, "isDefaultValue": true, "conditionalFields": [], "validationPattern": "^[0-9]+(\\.[0-9]{1,2})?$"}', 'published', 'text', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 2, 'hdb_registration_payment_detail.original_amount', 'originalPayment');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (30, 'Cheque no.', '{"minValue": 1, "dependsOn": [{"value": "Cheque", "questionId": 28}], "isRequired": true, "allowedDigits": 6}', 'published', 'number', '2025-06-02 22:27:21.378447+05:30', '2025-06-02 22:27:21.378447+05:30', NULL, -2, -2, 2, NULL, 'chequeNo');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (31, 'Bank name', '{"dependsOn": [{"value": "Cheque", "questionId": 28}, {"value": "Direct bank transfer (NEFT/RTGS)", "questionId": 28}], "isRequired": true}', 'published', 'select', '2025-06-02 22:28:28.888897+05:30', '2025-06-02 22:28:28.888897+05:30', NULL, -2, -2, 2, NULL, 'bankName');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (32, 'Other bank name', '{"dependsOn": [{"value": "Other", "questionId": 31}], "isRequired": true}', 'published', 'text', '2025-07-01 11:47:55.31882+05:30', '2025-07-01 11:47:55.31882+05:30', NULL, -2, -2, 2, NULL, 'otherBankName');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (33, 'Cheque date', '{"dependsOn": [{"value": "Cheque", "questionId": 28}], "isRequired": true, "pastValidation": {"unit": "days", "enabled": true, "maxValue": 60, "minValue": 0}, "futureValidation": {"unit": "days", "enabled": false, "maxValue": null, "minValue": null}, "dateTypeValidation": "dynamic"}', 'published', 'date', '2025-06-02 22:43:47.254272+05:30', '2025-06-02 22:43:47.254272+05:30', NULL, -2, -2, 2, NULL, 'chequeDate');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (34, 'Handover to', '{"type": "select", "endPoint": "user?filters=%7B%22role%22%3A%20%226%22%7D&limit=1000", "dependsOn": [{"value": "Cheque", "questionId": 28}, {"value": "Card swipe", "questionId": 28}, {"value": "Cash", "questionId": 28}], "isRequired": true}', 'published', 'apicall', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 2, NULL, 'handOverTo');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (35, 'Other', '{"dependsOn": [{"value": 9568, "questionId": 34}], "isRequired": true}', 'published', 'text', '2025-07-03 23:19:30.214259+05:30', '2025-07-03 23:19:30.214259+05:30', NULL, -2, -2, 2, NULL, 'otherRM');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (36, 'Handover date', '{"dependsOn": [{"value": "Cheque", "questionId": 28}, {"value": "Cash", "questionId": 28}], "isRequired": true, "pastValidation": {"unit": "year", "enabled": true, "maxValue": 1, "minValue": 0, "dateValidationField": "registrationStartsAt"}, "futureValidation": {"unit": "days", "enabled": false, "maxValue": null, "minValue": null}, "dateTypeValidation": "custom"}', 'published', 'date', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 2, NULL, 'handOverDate');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (37, 'Bank transfer date', '{"dependsOn": [{"value": "Direct bank transfer (NEFT/RTGS)", "questionId": 28}], "isRequired": true, "pastValidation": {"unit": "year", "enabled": true, "maxValue": 1, "minValue": 0, "dateValidationField": "registrationStartsAt"}, "futureValidation": {"unit": "days", "enabled": false, "maxValue": null, "minValue": null}, "dateTypeValidation": "custom"}', 'published', 'date', '2025-06-02 22:44:26.420871+05:30', '2025-06-02 22:44:26.420871+05:30', NULL, -2, -2, 2, NULL, 'bankTransferDate');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (38, 'UTR number', '{"dependsOn": [{"value": "Direct bank transfer (NEFT/RTGS)", "questionId": 28}], "isRequired": true}', 'published', 'text', '2025-06-02 22:44:51.448723+05:30', '2025-06-02 22:44:51.448723+05:30', NULL, -2, -2, 2, NULL, 'utrNumber');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (39, 'Swipe date', '{"dependsOn": [{"value": "Card swipe", "questionId": 28}], "isRequired": true, "pastValidation": {"unit": "year", "enabled": true, "maxValue": 1, "minValue": 0, "dateValidationField": "registrationStartsAt"}, "futureValidation": {"unit": "days", "enabled": false, "maxValue": null, "minValue": null}, "dateTypeValidation": "custom"}', 'published', 'date', '2025-06-02 22:45:13.920108+05:30', '2025-06-02 22:45:13.920108+05:30', NULL, -2, -2, 2, NULL, 'swipeDate');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (40, 'TID reference no.', '{"dependsOn": [{"value": "Card swipe", "questionId": 28}], "isRequired": true}', 'published', 'text', '2025-06-02 22:45:37.160127+05:30', '2025-06-02 22:45:37.160127+05:30', NULL, -2, -2, 2, NULL, 'tidReferenceNo');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (41, 'ID (Front / Front+Back)', '{"maxValue": null, "minValue": null, "dependsOn": [], "helperText": "In case of separate back side of the ID, please upload in the ID (only Back) input.", "isRequired": true, "minCharacter": null, "maxCharacters": null, "conditionalFields": [], "validationPattern": ""}', 'published', 'file', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 3, 'hdb_registration_travel_info.id_picture_url', 'pictureUrl');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (42, 'ID (only Back)', '{"filetype": "image"}', 'published', 'file', '2025-06-21 11:27:37.892156+05:30', '2025-06-21 11:27:37.892156+05:30', NULL, -2, -2, 3, NULL, 'idBack');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (43, 'ID type', '{"maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "minCharacter": null, "maxCharacters": null, "conditionalFields": [], "validationPattern": null}', 'published', 'select', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 3, 'hdb_registration_travel_info.id_type', 'travelInfoType');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (44, 'ID number', '{"maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "minCharacter": 5, "maxCharacters": 20, "conditionalFields": []}', 'published', 'text', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 3, 'hdb_registration_travel_info.id_number', 'travelInfoNumber');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (45, 'Uploaded International ID card', '{"isRequired": true}', 'published', 'radio', '2025-06-21 11:07:34.89641+05:30', '2025-06-21 11:07:34.89641+05:30', NULL, -2, -2, 3, NULL, 'internationalId');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (46, 'Upload passport copy', '{"filetype": "image", "dependsOn": [{"value": "yes", "questionId": 45}], "helperText": "Only for international travel, upload both front and back side of the Passport Copy.", "isRequired": true}', 'published', 'file', '2025-06-21 11:15:08.809948+05:30', '2025-06-21 11:15:08.809948+05:30', NULL, -2, -2, 3, NULL, 'passport');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (47, 'Upload VISA copy', '{"filetype": "image", "dependsOn": [{"value": "yes", "questionId": 45}], "helperText": "Only for international travel.", "isRequired": true}', 'published', 'file', '2025-06-21 11:16:06.016908+05:30', '2025-06-21 11:16:06.016908+05:30', NULL, -2, -2, 3, NULL, 'visa');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (48, 'Travel details', '{"isRequired": true}', 'published', 'radio', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 3, NULL, 'travelDetails');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (49, 'Travel plans - Onward', '{"dependsOn": [{"value": "I want to update now", "questionId": 48}], "isRequired": true, "showDialog": {"type": "card", "isShow": "City pick up", "imageName": "null", "contentType": "text", "dialogueContent": "City Pick-up Time: Buses will depart at 5:00 p.m. from Ratnadeep, East Marredpally, Secunderabad, on Wednesday, 18 September 2024.", "dialogueContentType": "dynamic"}, "showDialogMessage": [{"type": "card", "isShow": "city pick up", "imageName": null, "contentType": "text", "dialogueContent": "City Pick-up Time: Buses will depart at 5:00 p.m. from Ratnadeep, East Marredpally, Secunderabad, on Wednesday, 18 September 2024.", "dialogueContentType": "dynamic"}, {"type": "card", "isShow": "own transport", "imageName": null, "contentType": "text", "dialogueContent": "Check-in Time: From 4:00 p.m. to 9:00 p.m. on Wednesday, 18 September 2024, at Leonia.", "dialogueContentType": "dynamic"}, {"type": "card", "isShow": "flight", "imageName": null, "contentType": "text", "dialogueContent": "Airport Pick-up Time: Vehicles will depart from RGIA at 3:30 p.m. on Wednesday, 18 September 2024.", "dialogueContentType": "dynamic"}]}', 'published', 'radio', '2025-06-11 10:17:55.803848+05:30', '2025-06-11 10:17:55.803848+05:30', NULL, -2, -2, 3, 'hdb_registration_travel_plan.travel_type', 'travelPlanOnward');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (50, 'Upload your onward journey ticket', '{"dependsOn": [{"value": "Flight", "questionId": 49}]}', 'published', 'file', '2025-07-02 14:38:24.710449+05:30', '2025-07-02 14:38:24.710449+05:30', NULL, -2, -2, 3, NULL, 'uploadOnwardJourneyTicket');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (51, 'Airline name', '{"maxValue": null, "minValue": null, "dependsOn": [{"value": "Flight", "questionId": 49}], "isRequired": true, "minCharacter": 2, "maxCharacters": 50, "conditionalFields": [], "validationPattern": "^[a-zA-Z\\s]+$"}', 'published', 'text', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 3, 'hdb_registration_travel_plan.airline_name', 'airlineNameOnward');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (52, 'Flight number', '{"maxValue": null, "minValue": null, "dependsOn": [{"value": "Flight", "questionId": 49}], "isRequired": true, "minCharacter": 3, "maxCharacters": 10, "conditionalFields": [], "validationPattern": "^[A-Z0-9\\-]+$"}', 'published', 'text', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 3, 'hdb_registration_travel_plan.flight_number', 'flightNumberOnward');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (53, 'Coming from', '{"dependsOn": [{"value": "Flight", "questionId": 49}], "isRequired": true}', 'published', 'text', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 3, 'hdb_registration_travel_plan.arrival_from', 'comingFrom');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (54, 'Arrival date & time', '{"prefill": {"prefillType": "programDependent", "prefillDateFrom": "allocatedProgramStartsAt"}, "dependsOn": [{"value": "Flight", "questionId": 49}], "isRequired": true}', 'published', 'dateandtime', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 3, 'hdb_registration_travel_plan.arrival_datetime', 'arrivalDateTime');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (55, 'Onward additional information', '{"dependsOn": [{"value": "I want to update now", "questionId": 48}]}', 'published', 'textarea', '2025-06-21 11:22:51.510706+05:30', '2025-06-21 11:22:51.510706+05:30', NULL, -2, -2, 3, NULL, 'onwardInfo');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (56, 'Travel plans - Return', '{"dependsOn": [{"value": "I want to update now", "questionId": 48}], "isRequired": true, "showDialog": {"type": "card", "isShow": "City drop", "imageName": null, "contentType": "text", "dialogueContent": "City Drop Time: Buses will depart at 5:00 p.m. from Ratnadeep, East Marredpally, Secunderabad, on Wednesday, 18 September 2024.", "dialogueContentType": "dynamic"}, "showDialogMessage": [{"type": "card", "isShow": "city drop", "imageName": null, "contentType": "text", "dialogueContent": "City Drop Time: Buses will depart as per the usual schedule.", "dialogContentType": "dynamic"}, {"type": "card", "isShow": "own transport", "imageName": null, "contentType": "text", "dialogueContent": "Check-out Time: Latest by 2:00 p.m. on Saturday, 21 September 2024.", "dialogueContentType": "dynamic"}, {"type": "card", "isShow": "flight", "imageName": null, "contentType": "text", "dialogueContent": "Airport Drop-off Time: Vehicles will depart for the airport at 9:30 a.m. on Saturday, 21 September 2024.", "dialogueContentType": "dynamic"}]}', 'published', 'radio', '2025-06-11 10:18:12.154582+05:30', '2025-06-11 10:18:12.154582+05:30', NULL, -2, -2, 3, 'hdb_registration_travel_plan.return_travel_type', 'travelPlanReturn');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (57, 'Upload your return journey ticket', '{"dependsOn": [{"value": "Flight", "questionId": 56}]}', 'published', 'file', '2025-07-02 14:39:39.005465+05:30', '2025-07-02 14:39:39.005465+05:30', NULL, -2, -2, 3, NULL, 'uploadReturnJourneyTicket');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (58, 'Airline name', '{"dependsOn": [{"value": "Flight", "questionId": 56}], "isRequired": true}', 'published', 'text', '2025-06-15 19:50:55.265712+05:30', '2025-06-15 19:50:55.265712+05:30', NULL, -2, -2, 3, 'hdb_registration_travel_plan.departure_airline_name', 'airlineNameReturn');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (59, 'Flight number', '{"dependsOn": [{"value": "Flight", "questionId": 56}], "isRequired": true}', 'published', 'text', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 3, 'hdb_registration_travel_plan.departure_flight_number', 'flightNumberReturn');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (60, 'Going to', '{"dependsOn": [{"value": "Flight", "questionId": 56}], "isRequired": true}', 'published', 'text', '2025-06-21 11:48:38.131304+05:30', '2025-06-21 11:48:38.131304+05:30', NULL, -2, -2, 3, 'hdb_registration_travel_plan.departure_to', 'goingTo');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (61, 'Departure date & time', '{"prefill": {"prefillType": "programDependent", "prefillDateFrom": "allocatedProgramEndsAt"}, "dependsOn": [{"value": "Flight", "questionId": 56}], "isRequired": true}', 'published', 'dateandtime', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 3, 'hdb_registration_travel_plan.departure_datetime', 'departureDateTime');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (62, 'Return additional information', '{"dependsOn": [{"value": "I want to update now", "questionId": 48}]}', 'published', 'textarea', '2025-06-21 11:24:03.025948+05:30', '2025-06-21 11:24:03.025948+05:30', NULL, -2, -2, 3, NULL, 'returnInfo');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (63, 'What are your 3 most dominant emotions?', '{"isRequired": true, "minCharacter": 1, "maxCharacters": 111}', 'published', 'textarea', '2025-06-17 11:21:08.666259+05:30', '2025-06-17 11:21:08.666259+05:30', NULL, -2, -2, 4, NULL, 'QK_3DOM_EMOTIONS');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (64, 'Mention any 3 qualities that best describe you?', '{"isRequired": true, "minCharacter": 1, "maxCharacters": 111}', 'published', 'textarea', '2025-06-17 11:23:09.072294+05:30', '2025-06-17 11:23:09.072294+05:30', NULL, -2, -2, 4, NULL, 'QK_3QUALITIES');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (65, 'In a scale of ''1 to 11'' rate yourself in your holistic growth in the last 365 days.', '{"isRequired": true, "selectPlaceHolder": "Celebrate your journey — rate your growth from 1 to 11"}', 'published', 'select', '2025-06-17 11:23:43.473956+05:30', '2025-06-17 11:23:43.473956+05:30', NULL, -2, -2, 4, NULL, 'QK_RATE_HOLISTIC_GROWTH');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (66, 'Reflect on the highlights that made your last 365 days memorable.', '{"isRequired": true, "minCharacter": 1, "maxCharacters": 111}', 'published', 'textarea', '2025-06-18 11:25:01.244758+05:30', '2025-06-18 11:25:01.244758+05:30', NULL, -2, -2, 4, NULL, 'QK_HIGHLIGHTS');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (67, 'What aspect/s of your life do you think you have neglected in the last 365 days?', '{"isRequired": true, "minCharacter": 1, "maxCharacters": 111}', 'published', 'textarea', '2025-06-18 11:26:18.341491+05:30', '2025-06-18 11:26:18.341491+05:30', NULL, -2, -2, 4, NULL, 'QK_NEGLECT_ASPECTS');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (68, 'What aspect/s of your life do you intend to prioritise in the NEXT 365 days?', '{"isRequired": true, "minCharacter": 1, "maxCharacters": 111}', 'published', 'textarea', '2025-06-18 11:27:21.506647+05:30', '2025-06-18 11:27:21.506647+05:30', NULL, -2, -2, 4, NULL, 'QK_PRIORITY_ASPECTS');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (69, 'What puzzles you the most about human behaviour ( your own or others)?', '{"isRequired": true, "minCharacter": 1, "maxCharacters": 111}', 'published', 'textarea', '2025-06-18 11:27:42.017807+05:30', '2025-06-18 11:27:42.017807+05:30', NULL, -2, -2, 4, NULL, 'QK_HUMAN_BEHAVIOR_PUZZLE');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (70, 'If Mahatria can customise one session in HDB for you, what would you want that to be?', '{"isRequired": true, "minCharacter": 1, "maxCharacters": 111}', 'published', 'textarea', '2025-06-18 11:28:13.621128+05:30', '2025-06-18 11:28:13.621128+05:30', NULL, -2, -2, 4, NULL, 'QK_CUSTOM_SESSION');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (71, 'Song/album suggestion for HDB - option 1.', '{"isRequired": true, "minCharacter": 1, "maxCharacters": 111}', 'published', 'textarea', '2025-06-18 11:28:33.463539+05:30', '2025-06-18 11:28:33.463539+05:30', NULL, -2, -2, 4, NULL, 'QK_HDB_SONG_1');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (72, 'Song/album suggestion for HDB - option 2.', '{"isRequired": true, "minCharacter": 1, "maxCharacters": 111}', 'published', 'textarea', '2025-06-18 11:29:08.762787+05:30', '2025-06-18 11:29:08.762787+05:30', NULL, -2, -2, 4, NULL, 'QK_HDB_SONG_2');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (73, 'Mention one wisdom from infinitheism you wish the entire world to embrace.', '{"isRequired": true, "minCharacter": 1, "maxCharacters": 111}', 'published', 'textarea', '2025-06-18 11:29:26.364209+05:30', '2025-06-18 11:29:26.364209+05:30', NULL, -2, -2, 4, NULL, 'QK_INFINI_WISDOM');
INSERT INTO public.hdb_question (id, label, config, stats, typ, created_at, updated_at, deleted_at, created_by, updated_by, form_section_id, answer_location, binding_key) VALUES (74, 'I agree to receive information from infinitheism via SMS, WhatsApp, phone calls, and email.', '{"maxValue": null, "minValue": null, "dependsOn": [], "isRequired": true, "minCharacter": null, "maxCharacters": null, "conditionalFields": [], "validationPattern": null}', 'published', 'checkbox', '2025-05-28 13:09:06.782159+05:30', '2025-05-28 13:09:06.782159+05:30', NULL, -2, -2, 4, 'hdb_program_registration.terms_accepted', 'terms');


INSERT INTO public.hdb_option_category (id, name, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (1, 'Gender', '2025-05-28 16:36:36.094185+05:30', '2025-05-28 16:36:36.094185+05:30', NULL, -2, -2);
INSERT INTO public.hdb_option_category (id, name, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (2, 'Payment mode', '2025-05-28 17:11:16.993599+05:30', '2025-06-20 12:00:42.018261+05:30', '2025-06-20 12:00:42.018261+05:30', -2, -2);
INSERT INTO public.hdb_option_category (id, name, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (3, 'Id type', '2025-05-28 17:13:09.597627+05:30', '2025-05-28 17:13:09.597627+05:30', NULL, -2, -2);
INSERT INTO public.hdb_option_category (id, name, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (4, 'Tshirt size', '2025-05-28 17:15:22.04401+05:30', '2025-05-28 17:15:22.04401+05:30', NULL, -2, -2);
INSERT INTO public.hdb_option_category (id, name, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (5, 'city', '2025-06-01 22:47:15.730021+05:30', '2025-06-01 22:47:15.730021+05:30', NULL, -2, -2);
INSERT INTO public.hdb_option_category (id, name, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (6, 'bank name', '2025-06-02 22:32:11.630264+05:30', '2025-06-02 22:32:11.630264+05:30', NULL, -2, -2);
INSERT INTO public.hdb_option_category (id, name, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (7, 'Travel Plan', '2025-06-11 10:14:29.91432+05:30', '2025-06-11 10:14:29.91432+05:30', NULL, -2, -2);
INSERT INTO public.hdb_option_category (id, name, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (8, 'self rating', '2025-06-26 17:07:46.818605+05:30', '2025-06-26 17:07:46.818605+05:30', NULL, -2, -2);

INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (28, 'string', NULL, '2025-05-28 17:08:08.227462+05:30', '2025-05-28 17:08:08.227462+05:30', NULL, 'published', -2, -2, 'yes');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (29, 'string', NULL, '2025-05-28 17:08:08.227462+05:30', '2025-05-28 17:08:08.227462+05:30', NULL, 'published', -2, -2, 'yes');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (30, 'string', NULL, '2025-05-28 17:08:08.227462+05:30', '2025-05-28 17:08:08.227462+05:30', NULL, 'published', -2, -2, 'yes');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (31, 'string', NULL, '2025-05-28 17:08:08.227462+05:30', '2025-05-28 17:08:08.227462+05:30', NULL, 'published', -2, -2, 'yes');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (32, 'string', NULL, '2025-05-28 17:08:13.683908+05:30', '2025-05-28 17:08:13.683908+05:30', NULL, 'published', -2, -2, 'no');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (33, 'string', NULL, '2025-05-28 17:08:13.683908+05:30', '2025-05-28 17:08:13.683908+05:30', NULL, 'published', -2, -2, 'no');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (34, 'string', NULL, '2025-05-28 17:08:13.683908+05:30', '2025-05-28 17:08:13.683908+05:30', NULL, 'published', -2, -2, 'no');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (49, 'string', NULL, '2025-05-28 17:17:42.952688+05:30', '2025-05-28 17:17:42.952688+05:30', NULL, 'published', -2, -2, 'I want to update now');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (50, 'string', NULL, '2025-05-28 17:17:49.070565+05:30', '2025-05-28 17:17:49.070565+05:30', NULL, 'published', -2, -2, 'I want to update later');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (95, 'primarybutton', NULL, '2025-06-20 14:58:12.052087+05:30', '2025-06-20 14:58:12.052087+05:30', NULL, 'published', -2, -2, 'upload file');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (96, 'secondarybutton', NULL, '2025-06-20 14:59:18.106696+05:30', '2025-06-20 14:59:18.106696+05:30', NULL, 'published', -2, -2, 'fill in manually');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (97, 'number', 8, '2025-06-26 17:08:12.16232+05:30', '2025-06-26 17:08:12.16232+05:30', NULL, 'published', -2, -2, '1');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (98, 'number', 8, '2025-06-26 17:08:28.893302+05:30', '2025-06-26 17:08:28.893302+05:30', NULL, 'published', -2, -2, '2');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (99, 'number', 8, '2025-06-26 17:08:33.72293+05:30', '2025-06-26 17:08:33.72293+05:30', NULL, 'published', -2, -2, '3');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (100, 'number', 8, '2025-06-26 17:08:37.500862+05:30', '2025-06-26 17:08:37.500862+05:30', NULL, 'published', -2, -2, '4');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (101, 'number', 8, '2025-06-26 17:08:40.628915+05:30', '2025-06-26 17:08:40.628915+05:30', NULL, 'published', -2, -2, '5');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (102, 'number', 8, '2025-06-26 17:08:43.756303+05:30', '2025-06-26 17:08:43.756303+05:30', NULL, 'published', -2, -2, '6');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (103, 'number', 8, '2025-06-26 17:08:47.477878+05:30', '2025-06-26 17:08:47.477878+05:30', NULL, 'published', -2, -2, '7');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (104, 'number', 8, '2025-06-26 17:08:51.292829+05:30', '2025-06-26 17:08:51.292829+05:30', NULL, 'published', -2, -2, '8');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (105, 'number', 8, '2025-06-26 17:08:56.032081+05:30', '2025-06-26 17:08:56.032081+05:30', NULL, 'published', -2, -2, '9');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (106, 'number', 8, '2025-06-26 17:08:59.575369+05:30', '2025-06-26 17:08:59.575369+05:30', NULL, 'published', -2, -2, '10');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (107, 'number', 8, '2025-06-26 17:09:02.089259+05:30', '2025-06-26 17:09:02.089259+05:30', NULL, 'published', -2, -2, '11');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (1, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'Punjab National Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (2, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'State Bank of India');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (3, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'UCO Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (4, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'Union Bank of India');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (5, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'Axis Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (6, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'Bandhan Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (7, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'CSB Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (8, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'City Union Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (9, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'DCB Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (10, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'Dhanlaxmi Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (11, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'Federal Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (12, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'HDFC Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (13, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'ICICI Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (14, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'IDBI Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (15, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'IDFC First Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (16, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'IndusInd Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (17, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'Karnataka Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (18, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'Karur Vysya Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (19, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'Kotak Mahindra Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (20, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'Nainital Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (21, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'RBL Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (22, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'South Indian Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (23, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'Tamilnad Mercantile Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (24, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'Yes Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (25, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'Jammu & Kashmir Bank Ltd');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (81, 'string', 6, '2025-06-02 22:32:29.058906+05:30', '2025-06-02 22:32:29.058906+05:30', NULL, 'published', -2, -2, 'Bank of Baroda');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (82, 'string', 6, '2025-06-02 22:32:47.606257+05:30', '2025-06-02 22:32:47.606257+05:30', NULL, 'published', -2, -2, 'Bank of India');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (83, 'string', 6, '2025-06-02 22:33:06.53882+05:30', '2025-06-02 22:33:06.53882+05:30', NULL, 'published', -2, -2, 'Bank of Maharashtra');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (84, 'string', 6, '2025-06-02 22:33:22.077328+05:30', '2025-06-02 22:33:22.077328+05:30', NULL, 'published', -2, -2, 'Canara Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (85, 'string', 6, '2025-06-02 22:33:51.415255+05:30', '2025-06-02 22:33:51.415255+05:30', NULL, 'published', -2, -2, 'Central Bank of India');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (86, 'string', 6, '2025-06-02 22:34:04.623012+05:30', '2025-06-02 22:34:04.623012+05:30', NULL, 'published', -2, -2, 'Indian Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (87, 'string', 6, '2025-06-02 22:34:19.536066+05:30', '2025-06-02 22:34:19.536066+05:30', NULL, 'published', -2, -2, 'Indian Overseas Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (88, 'string', 6, '2025-06-02 22:34:34.887762+05:30', '2025-06-02 22:34:34.887762+05:30', NULL, 'published', -2, -2, 'Punjab and Sind Bank');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (89, 'string', 6, '2025-06-02 22:38:38.461889+05:30', '2025-06-02 22:38:38.461889+05:30', NULL, 'published', -2, -2, 'Other');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (35, 'string', 2, '2025-05-28 17:11:44.649957+05:30', '2025-05-28 17:11:44.649957+05:30', NULL, 'published', -2, -2, 'online');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (36, 'string', 2, '2025-05-28 17:11:51.983468+05:30', '2025-05-28 17:11:51.983468+05:30', NULL, 'published', -2, -2, 'offline');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (76, 'string', 2, '2025-06-02 20:27:37.782966+05:30', '2025-06-02 20:27:37.782966+05:30', NULL, 'published', -2, -2, 'Cheque');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (77, 'string', 2, '2025-06-02 20:28:13.752408+05:30', '2025-06-02 20:28:13.752408+05:30', NULL, 'published', -2, -2, 'Direct bank transfer (NEFT/RTGS)');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (78, 'string', 2, '2025-06-02 20:28:37.45383+05:30', '2025-06-02 20:28:37.45383+05:30', NULL, 'published', -2, -2, 'Card swipe');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (79, 'string', 2, '2025-06-02 20:28:55.824289+05:30', '2025-06-02 20:28:55.824289+05:30', NULL, 'published', -2, -2, 'Cash');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (80, 'string', 2, '2025-06-02 20:29:33.852753+05:30', '2025-06-02 20:29:33.852753+05:30', NULL, 'published', -2, -2, 'Online (Through Razorpay)');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (51, 'string', 5, '2025-06-01 22:47:45.931639+05:30', '2025-06-01 22:47:45.931639+05:30', NULL, 'published', -2, -2, 'Hyderabad');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (52, 'string', 5, '2025-06-01 22:48:42.01211+05:30', '2025-06-01 22:48:42.01211+05:30', NULL, 'published', -2, -2, 'Mumbai');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (53, 'string', 5, '2025-06-01 22:48:55.755841+05:30', '2025-06-01 22:48:55.755841+05:30', NULL, 'published', -2, -2, 'Delhi');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (54, 'string', 5, '2025-06-01 22:49:02.439332+05:30', '2025-06-01 22:49:02.439332+05:30', NULL, 'published', -2, -2, 'Bangalore');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (55, 'string', 5, '2025-06-01 22:49:41.761805+05:30', '2025-06-01 22:49:41.761805+05:30', NULL, 'published', -2, -2, 'Kolkata');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (56, 'string', 5, '2025-06-01 22:50:00.741968+05:30', '2025-06-01 22:50:00.741968+05:30', NULL, 'published', -2, -2, 'Pune');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (57, 'string', 5, '2025-06-01 22:50:15.161855+05:30', '2025-06-01 22:50:15.161855+05:30', NULL, 'published', -2, -2, 'Ahmedabad');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (58, 'string', 5, '2025-06-01 22:50:23.902149+05:30', '2025-06-01 22:50:23.902149+05:30', NULL, 'published', -2, -2, 'Jaipur');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (59, 'string', 5, '2025-06-01 22:50:34.880997+05:30', '2025-06-01 22:50:34.880997+05:30', NULL, 'published', -2, -2, 'Surat');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (60, 'string', 5, '2025-06-01 22:50:44.783911+05:30', '2025-06-01 22:50:44.783911+05:30', NULL, 'published', -2, -2, 'Lucknow');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (61, 'string', 5, '2025-06-01 22:50:51.164343+05:30', '2025-06-01 22:50:51.164343+05:30', NULL, 'published', -2, -2, 'Kanpur');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (62, 'string', 5, '2025-06-01 22:50:57.074439+05:30', '2025-06-01 22:50:57.074439+05:30', NULL, 'published', -2, -2, 'Nagpur');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (63, 'string', 5, '2025-06-01 22:51:04.074844+05:30', '2025-06-01 22:51:04.074844+05:30', NULL, 'published', -2, -2, 'Patna');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (64, 'string', 5, '2025-06-01 22:51:16.706237+05:30', '2025-06-01 22:51:16.706237+05:30', NULL, 'published', -2, -2, 'Indore');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (65, 'string', 5, '2025-06-01 22:51:27.157507+05:30', '2025-06-01 22:51:27.157507+05:30', NULL, 'published', -2, -2, 'Bhopal');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (66, 'string', 5, '2025-06-01 22:51:36.047092+05:30', '2025-06-01 22:51:36.047092+05:30', NULL, 'published', -2, -2, 'Vadodara');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (67, 'string', 5, '2025-06-01 22:51:52.799271+05:30', '2025-06-01 22:51:52.799271+05:30', NULL, 'published', -2, -2, 'Ludhiana');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (68, 'string', 5, '2025-06-01 22:52:01.319134+05:30', '2025-06-01 22:52:01.319134+05:30', NULL, 'published', -2, -2, 'Agra');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (69, 'string', 5, '2025-06-01 22:52:10.056722+05:30', '2025-06-01 22:52:10.056722+05:30', NULL, 'published', -2, -2, 'Varanasi');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (70, 'string', 5, '2025-06-01 22:52:18.214029+05:30', '2025-06-01 22:52:18.214029+05:30', NULL, 'published', -2, -2, 'Amritsar');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (71, 'string', 5, '2025-06-01 22:52:24.07542+05:30', '2025-06-01 22:52:24.07542+05:30', NULL, 'published', -2, -2, 'Coimbatore');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (72, 'string', 5, '2025-06-01 22:52:31.20964+05:30', '2025-06-01 22:52:31.20964+05:30', NULL, 'published', -2, -2, 'Thiruvananthapuram');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (73, 'string', 5, '2025-06-01 22:52:37.271534+05:30', '2025-06-01 22:52:37.271534+05:30', NULL, 'published', -2, -2, 'Guwahati');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (74, 'string', 5, '2025-06-01 22:52:43.90656+05:30', '2025-06-01 22:52:43.90656+05:30', NULL, 'published', -2, -2, 'Ranchi');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (75, 'string', 5, '2025-06-01 22:52:50.527737+05:30', '2025-06-01 22:52:50.527737+05:30', NULL, 'published', -2, -2, 'Other');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (37, 'string', 3, '2025-05-28 17:13:23.01534+05:30', '2025-05-28 17:13:23.01534+05:30', NULL, 'published', -2, -2, 'Passport');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (38, 'string', 3, '2025-05-28 17:13:37.369415+05:30', '2025-05-28 17:13:37.369415+05:30', NULL, 'published', -2, -2, 'Aadhar');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (39, 'string', 3, '2025-05-28 17:13:48.790878+05:30', '2025-05-28 17:13:48.790878+05:30', NULL, 'published', -2, -2, 'Driving license');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (40, 'string', 3, '2025-05-28 17:13:59.266378+05:30', '2025-05-28 17:13:59.266378+05:30', NULL, 'published', -2, -2, 'Voter id');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (41, 'string', 3, '2025-05-28 17:14:07.933066+05:30', '2025-05-28 17:14:07.933066+05:30', NULL, 'published', -2, -2, 'Pan card');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (90, 'string', 7, '2025-06-11 10:14:56.777329+05:30', '2025-06-11 10:14:56.777329+05:30', NULL, 'published', -2, -2, 'Flight');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (91, 'string', 7, '2025-06-11 10:14:56.777329+05:30', '2025-06-11 10:14:56.777329+05:30', NULL, 'published', -2, -2, 'Flight');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (92, 'string', 7, '2025-06-11 10:16:19.747623+05:30', '2025-06-11 10:16:19.747623+05:30', NULL, 'published', -2, -2, 'Own transport');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (93, 'string', 7, '2025-06-11 10:16:19.747623+05:30', '2025-06-11 10:16:19.747623+05:30', NULL, 'published', -2, -2, 'Own transport');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (94, 'string', 7, '2025-06-14 19:29:12.290759+05:30', '2025-06-14 19:29:12.290759+05:30', NULL, 'published', -2, -2, 'City drop');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (108, 'string', 7, '2025-07-09 18:20:35.367085+05:30', '2025-07-09 18:20:35.367085+05:30', NULL, 'published', -2, -2, 'City pick up');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (42, 'string', 4, '2025-05-28 17:15:38.948194+05:30', '2025-05-28 17:15:38.948194+05:30', NULL, 'published', -2, -2, 'XS');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (43, 'string', 4, '2025-05-28 17:15:46.058572+05:30', '2025-05-28 17:15:46.058572+05:30', NULL, 'published', -2, -2, 'S');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (44, 'string', 4, '2025-05-28 17:15:56.242025+05:30', '2025-05-28 17:15:56.242025+05:30', NULL, 'published', -2, -2, 'M');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (45, 'string', 4, '2025-05-28 17:16:11.842555+05:30', '2025-05-28 17:16:11.842555+05:30', NULL, 'published', -2, -2, 'L');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (46, 'string', 4, '2025-05-28 17:16:19.159994+05:30', '2025-05-28 17:16:19.159994+05:30', NULL, 'published', -2, -2, 'XL');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (47, 'string', 4, '2025-05-28 17:16:23.451302+05:30', '2025-05-28 17:16:23.451302+05:30', NULL, 'published', -2, -2, 'XXL');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (48, 'string', 4, '2025-05-28 17:16:28.698359+05:30', '2025-05-28 17:16:28.698359+05:30', NULL, 'published', -2, -2, 'XXXL');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (26, 'string', 1, '2025-05-28 16:37:32.057342+05:30', '2025-05-28 16:37:32.057342+05:30', NULL, 'published', -2, -2, 'male');
INSERT INTO public.hdb_option (id, typ, category_id, created_at, updated_at, deleted_at, stats, created_by, updated_by, name) VALUES (27, 'string', 1, '2025-05-28 16:37:55.443639+05:30', '2025-05-28 16:37:55.443639+05:30', NULL, 'published', -2, -2, 'female');


INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (1, 2, 26, '2025-05-28 16:43:58.833799+05:30', '2025-05-28 16:43:58.833799+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (2, 2, 27, '2025-05-28 16:43:58.833799+05:30', '2025-05-28 16:43:58.833799+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (3, 6, 51, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (4, 6, 52, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (5, 6, 53, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (6, 6, 54, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (7, 6, 55, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (8, 6, 56, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (9, 6, 57, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (10, 6, 58, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (11, 6, 59, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (12, 6, 60, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (13, 6, 61, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (14, 6, 62, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (15, 6, 63, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (16, 6, 64, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (17, 6, 65, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (18, 6, 66, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (19, 6, 67, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (20, 6, 68, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (21, 6, 69, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (22, 6, 70, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (23, 6, 71, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (24, 6, 72, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (25, 6, 73, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (26, 6, 74, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (27, 6, 75, '2025-06-02 23:01:40.615616+05:30', '2025-06-02 23:01:40.615616+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (28, 19, 31, '2025-06-20 17:28:17.511672+05:30', '2025-06-20 17:28:17.511672+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (29, 19, 34, '2025-06-20 17:28:17.511672+05:30', '2025-06-20 17:28:17.511672+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (30, 22, 31, '2025-05-28 17:08:35.444781+05:30', '2025-05-28 17:08:35.444781+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (31, 22, 34, '2025-05-28 17:08:35.444781+05:30', '2025-05-28 17:08:35.444781+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (32, 28, 35, '2025-05-28 17:12:14.875384+05:30', '2025-05-28 17:12:14.875384+05:30', '2025-05-28 17:11:44.649957+05:30', -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (33, 28, 36, '2025-05-28 17:12:14.875384+05:30', '2025-05-28 17:12:14.875384+05:30', '2025-05-28 17:11:44.649957+05:30', -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (34, 28, 76, '2025-06-16 16:42:08.933131+05:30', '2025-06-16 16:42:08.933131+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (35, 28, 77, '2025-06-16 16:42:08.933131+05:30', '2025-06-16 16:42:08.933131+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (36, 28, 78, '2025-06-16 16:42:08.933131+05:30', '2025-06-16 16:42:08.933131+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (37, 28, 79, '2025-06-16 16:42:08.933131+05:30', '2025-06-16 16:42:08.933131+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (38, 28, 80, '2025-06-16 16:42:08.933131+05:30', '2025-06-16 16:42:08.933131+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (39, 31, 1, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (40, 31, 2, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (41, 31, 3, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (42, 31, 4, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (43, 31, 5, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (44, 31, 6, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (45, 31, 7, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (46, 31, 8, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (47, 31, 9, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (48, 31, 10, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (49, 31, 11, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (50, 31, 12, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (51, 31, 13, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (52, 31, 14, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (53, 31, 15, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (54, 31, 16, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (55, 31, 17, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (56, 31, 18, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (57, 31, 19, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (58, 31, 20, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (59, 31, 21, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (60, 31, 22, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (61, 31, 23, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (62, 31, 24, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (63, 31, 25, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (64, 31, 75, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (65, 31, 81, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (66, 31, 82, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (67, 31, 83, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (68, 31, 84, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (69, 31, 85, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (70, 31, 86, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (71, 31, 87, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (72, 31, 88, '2025-06-02 22:42:28.791089+05:30', '2025-06-02 22:42:28.791089+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (73, 43, 37, '2025-05-28 17:14:43.859713+05:30', '2025-05-28 17:14:43.859713+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (74, 43, 38, '2025-05-28 17:14:43.859713+05:30', '2025-05-28 17:14:43.859713+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (75, 43, 39, '2025-05-28 17:14:43.859713+05:30', '2025-05-28 17:14:43.859713+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (76, 43, 40, '2025-05-28 17:14:43.859713+05:30', '2025-05-28 17:14:43.859713+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (77, 43, 41, '2025-05-28 17:14:43.859713+05:30', '2025-05-28 17:14:43.859713+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (78, 45, 31, '2025-06-21 11:10:28.800179+05:30', '2025-06-21 11:10:28.800179+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (79, 45, 34, '2025-06-21 11:10:28.800179+05:30', '2025-06-21 11:10:28.800179+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (80, 48, 49, '2025-05-28 17:18:06.798402+05:30', '2025-05-28 17:18:06.798402+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (81, 48, 50, '2025-05-28 17:18:06.798402+05:30', '2025-05-28 17:18:06.798402+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (82, 49, 91, '2025-06-17 10:17:17.060762+05:30', '2025-06-17 10:17:17.060762+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (83, 49, 93, '2025-06-17 10:17:17.060762+05:30', '2025-06-17 10:17:17.060762+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (84, 49, 108, '2025-06-17 10:17:17.060762+05:30', '2025-06-17 10:17:17.060762+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (85, 56, 91, '2025-06-11 10:18:59.307954+05:30', '2025-06-11 10:18:59.307954+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (86, 56, 93, '2025-06-11 10:18:59.307954+05:30', '2025-06-11 10:18:59.307954+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (87, 56, 94, '2025-06-14 19:29:54.644734+05:30', '2025-06-14 19:29:54.644734+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (88, 65, 97, '2025-06-26 17:10:32.79207+05:30', '2025-06-26 17:10:32.79207+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (89, 65, 98, '2025-06-26 17:10:32.79207+05:30', '2025-06-26 17:10:32.79207+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (90, 65, 99, '2025-06-26 17:10:32.79207+05:30', '2025-06-26 17:10:32.79207+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (91, 65, 100, '2025-06-26 17:10:32.79207+05:30', '2025-06-26 17:10:32.79207+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (92, 65, 101, '2025-06-26 17:10:32.79207+05:30', '2025-06-26 17:10:32.79207+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (93, 65, 102, '2025-06-26 17:10:32.79207+05:30', '2025-06-26 17:10:32.79207+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (94, 65, 103, '2025-06-26 17:10:32.79207+05:30', '2025-06-26 17:10:32.79207+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (95, 65, 104, '2025-06-26 17:10:32.79207+05:30', '2025-06-26 17:10:32.79207+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (96, 65, 105, '2025-06-26 17:10:32.79207+05:30', '2025-06-26 17:10:32.79207+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (97, 65, 106, '2025-06-26 17:10:32.79207+05:30', '2025-06-26 17:10:32.79207+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (98, 65, 107, '2025-06-26 17:10:32.79207+05:30', '2025-06-26 17:10:32.79207+05:30', NULL, -2, -2);
INSERT INTO public.hdb_question_option_map (id, question_id, option_id, created_at, updated_at, deleted_at, created_by, updated_by) VALUES (99, 74, 31, '2025-06-01 23:20:41.202752+05:30', '2025-06-01 23:20:41.202752+05:30', NULL, -2, -2);


INSERT INTO user_role_map (user_id, role_id, created_at, updated_at)
SELECT 
    id AS user_id,
    1 AS role_id,
    NOW() AS created_at,
    NOW() AS updated_at
FROM users;


-- 1. feature_flag
SELECT setval('feature_flag_id_seq', (SELECT COALESCE(MAX(id), 0) + 1 FROM feature_flag));

-- 2. hdb_form_section
SELECT setval('hdb_form_section_id_seq', (SELECT COALESCE(MAX(id), 0) + 1 FROM hdb_form_section));

-- 3. program_type_v1
SELECT setval('program_type_v1_id_seq', (SELECT COALESCE(MAX(id), 0) + 1 FROM program_type_v1));

-- 4. hdb_program_registration_rm_rating_type. 
SELECT setval('hdb_program_registration_rm_rating_type_id_seq', (SELECT COALESCE(MAX(id), 0) + 1 FROM hdb_program_registration_rm_rating_type));


-- 5. lookup_data
SELECT setval('lookup_data_id_seq', (SELECT COALESCE(MAX(id), 0) + 5 FROM lookup_data));

-- 6. user_role
SELECT setval('user_role_id_seq', (SELECT COALESCE(MAX(id), 0) + 1 FROM user_role));

-- 7. hdb_option_category
SELECT setval('hdb_option_category_id_seq', (SELECT COALESCE(MAX(id), 0) + 1 FROM hdb_option_category));

-- 8. hdb_option
SELECT setval('hdb_option_id_seq', (SELECT COALESCE(MAX(id), 0) + 5 FROM hdb_option));

-- 9. hdb_question
SELECT setval('hdb_question_id_seq', (SELECT COALESCE(MAX(id), 0) + 5 FROM hdb_question));

-- 10. hdb_question_option_map
SELECT setval('hdb_question_option_map_id_seq', (SELECT COALESCE(MAX(id), 0) + 10 FROM hdb_question_option_map));

-- 11 program_v1
SELECT setval('program_v1_id_seq', (SELECT COALESCE(MAX(id), 0) + 1 FROM program_v1));

--12 role map
SELECT setval('user_role_map_id_seq', (SELECT COALESCE(MAX(id), 0) + 5 FROM user_role_map));



-- update existing user role seeker to viewer
UPDATE users
SET role = 'viewer'
where role = 'seeker'; -- 443