import { Column, Entity, PrimaryGeneratedColumn } from 'typeorm';
/**
 * Entity definition for Users table.
 * Represents a user in the system with various personal and account-related details.
 */
@Entity({ name: 'users' })
export class Users {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  phone_number: number;

  @Column()
  full_name: string;

  @Column()
  role: string;

  @Column()
  created_at: Date;

  @Column()
  updated_at: Date;

  @Column()
  is_infiminute: boolean;

  @Column()
  is_infimessages: boolean;

  @Column()
  user_approval_status: string;

  @Column()
  first_name: string;

  @Column()
  last_name: string;

  @Column()
  status_updated_at: Date;

  @Column()
  is_infipath: boolean;

  @Column()
  email: string;

  @Column()
  is_infimessage_user_active: boolean;

  @Column()
  is_infipath_user_active: boolean;

  @Column()
  name_audio: string;

  @Column()
  profile_url: string;

  @Column()
  address: string;

  @Column()
  country_code: string;

  @Column()
  dob: string;

  @Column()
  other_address: string;

  @Column()
  firebase_id_ext: string;

  /**
   * Constructor for Users entity.
   * @param phone_number - User's phone number
   * @param full_name - User's full name
   * @param role - User role
   * @param created_at - Account creation date
   * @param updated_at - Last update date
   * @param is_infiminute - Subscription status for Infiminute
   * @param is_infimessages - Subscription status for Infimessages
   * @param user_approval_status - User approval status
   * @param first_name - User's first name
   * @param last_name - User's last name
   * @param status_updated_at - Status update timestamp
   * @param is_infipath - Subscription status for Infipath
   * @param email - User email
   * @param is_infimessage_user_active - Active status for Infimessage
   * @param is_infipath_user_active - Active status for Infipath
   * @param country_code - User's country code (optional)
   * @param address - User's address (optional)
   * @param dob - Date of birth (optional)
   * @param other_address - Additional address (optional)
   * @param profile_url - Profile picture URL (optional)
   * @param firebase_id_ext - Firebase ID extension (optional)
   */
  constructor(
    phone_number: number,
    full_name: string,
    role: string,
    created_at: Date,
    updated_at: Date,
    is_infiminute: boolean,
    is_infimessages: boolean,
    user_approval_status: string,
    first_name: string,
    last_name: string,
    status_updated_at: Date,
    is_infipath: boolean,
    email: string,
    is_infimessage_user_active: boolean,
    is_infipath_user_active: boolean,
    country_code?: string,
    address?: string,
    dob?: string,
    other_address?: string,
    profile_url?: string,
    firebase_id_ext?: string
  ) {
    this.phone_number = phone_number;
    this.full_name = full_name;
    this.role = role;
    this.created_at = created_at;
    this.updated_at = updated_at;
    this.is_infiminute = is_infiminute;
    this.is_infimessages = is_infimessages;
    this.user_approval_status = user_approval_status;
    this.first_name = first_name;
    this.last_name = last_name;
    this.status_updated_at = status_updated_at;
    this.is_infipath = is_infipath;
    this.email = email;
    this.is_infimessage_user_active = is_infimessage_user_active;
    this.is_infipath_user_active = is_infipath_user_active;
    this.address = address;
    this.country_code = country_code;
    this.dob = dob;
    this.other_address = other_address;
    this.profile_url = profile_url;
    this.firebase_id_ext = firebase_id_ext;
  }
}
