/**
 * Import entity models for the application.
 * These models are used for database interactions.
 */
import { Users } from "./users";
import { Webinar } from "./webinar";
import { WebinarAttendee } from "./webinar_attendee";
import { WebinarRegistration } from "./webinar_registration";
import { WebinarRegistrationTransaction } from "./webinar_registration_transaction";

/**
 * Re-export all entity modules for easy access in other parts of the application.
 */
export * from "./users";
export * from "./webinar";
export * from "./webinar_attendee";
export * from "./webinar_registration";
export * from "./webinar_registration_transaction";

/**
 * Array of all entity classes used in the database schema.
 * This is typically used in the ORM configuration.
 */
export const entities: any = [
  Users,
  Webinar,
  WebinarAttendee,
  WebinarRegistration,
  WebinarRegistrationTransaction,
];
