import dotenv from "dotenv"; // Import dotenv for environment variables

dotenv.config(); // Load environment variables from .env file
/**
 * Registration Status
 */
export const registrationStatus = {
  opened: "OPENED",
  closed: "CLOSED",
  notOpened: "NOT OPENED",
  live: "WEBINAR LIVE",
  ended: "WEBINAR ENDED",
};

/***
 * Database details
 */
export const databaseType = "postgres";
export const dbPort = 5432;

/**
 * User Role Details
 */
export const userRole = {
  role: "viewer",
};

/**
 * Firebase account credentials
 */
export const firebaseAccountCredentials = {
  type: process.env.TYPE,
  project_id: process.env.PROJECT_ID,
  private_key_id: process.env.PRIVATE_KEY_ID,
  private_key: process.env.PRIVATE_KEY,
  client_email: process.env.CLIENT_EMAIL,
  client_id: process.env.CLIENT_ID,
  auth_uri: process.env.TOKEN_URI,
  token_uri: process.env.TOKEN_URI,
  auth_provider_x509_cert_url: process.env.AUTH_CERT_URL,
  client_x509_cert_url: process.env.CLIENT_CERT_URL,
  universe_domain: process.env.UNIVERSE_DOMAIN,
};
