import { DataSource } from "typeorm"; // Import the datasource object from typeorm
import { entities } from "../entities"; // Import all the default entities
import { databaseType, dbPort } from "../common/constants"; // Import the default database details
import { createLogger } from "../utils/winstonLogger"; // Import the logger function
export let AppDataSource: DataSource;
const logger = createLogger;
/**
 * Initiate Client Connection
 * @returns returns the data source
 */
export const initiateClientConnection = async () => {
  if (!AppDataSource) {
    // checking the existing the datasource connection
    logger.info(`Initatilizing the database connection`);
    AppDataSource = new DataSource({
      type: databaseType, // retrieve the database type from the constants
      host: process.env.DB_HOST, // Db host environment variables
      port: dbPort, // retrieve the database port number from the constants
      username: process.env.DB_USER, // Db user environment variables
      password: process.env.DB_PASSWORD, // Db password environment variables
      database: process.env.DB_NAME, // Db name environment variables
      entities: entities, // Load all the Table entites
    });

    await AppDataSource.initialize() // Initatlize the Database Connection
      .then(() => {
        logger.info(
          `Data Source has been initialized: ${AppDataSource.options.database}`
        );
      })
      .catch((err) => {
        logger.error(`Error during Data Source initialization : ${err}`);
      });
  } else {
    logger.info(`Connection already initialized`);
  }
};
