import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import {
  Program,
  ProgramSession,
  ProgramQuestion,
  Question,
  ProgramRegistration,
  RegistrationApproval,
  RegistrationCustomResponse,
  ProgramRegistrationFailure,
  RegistrationInvoiceDetail,
  RegistrationPaymentDetail,
  RegistrationTravelInfo,
  RegistrationTravelPlan,
  RegistrationQuestionAnswer,
  User,
  Preference,
  CommunicationTrack,
  ProgramRegistrationSwap,
  ProgramRegistrationRmRating,
} from 'src/common/entities';
import { RegistrationController } from './registration.controller';
import { RegistrationService } from './registration.service';
import { RegistrationRepository } from './registration.repository';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { PreferenceModule } from 'src/preference/preference.module';
import { CommunicationService } from 'src/communication/communication.service';
import { CommunicationRepository } from 'src/communication/communication.repository';
import { ExcelService } from 'src/common/services/excel.service';
import { AwsS3Service } from 'src/common/services/awsS3.service';
import { ProgramRegistrationRepository } from 'src/program-registration/program-registration.repository';
import { ProgramRegistrationSwapRepository } from 'src/program-registration/repositories/program-registration-swap.repository';
import { ProgramRegistrationService } from 'src/program-registration/program-registration.service';
import { ProgramModule } from 'src/program/program.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([
      Program,
      ProgramSession,
      ProgramQuestion,
      Question,
      ProgramRegistration,
      RegistrationApproval,
      RegistrationCustomResponse,
      ProgramRegistrationFailure,
      RegistrationInvoiceDetail,
      RegistrationPaymentDetail,
      RegistrationTravelInfo,
      RegistrationTravelPlan,
      RegistrationQuestionAnswer,
      User,
      Preference,
      CommunicationTrack,
      ProgramRegistrationSwap,
      ProgramRegistrationRmRating
    ]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
    forwardRef(() => PreferenceModule),
    forwardRef(() => ProgramModule)
  ],
  controllers: [RegistrationController],
  providers: [
    RegistrationService, 
    RegistrationRepository, 
    CommonDataService, 
    AppLoggerService, 
    CommunicationService, 
    CommunicationRepository, 
    ExcelService,
    AwsS3Service,
    ProgramRegistrationRepository,
    ProgramRegistrationSwapRepository,
    ProgramRegistrationService,
  ],
  exports: [RegistrationService, RegistrationRepository],
})
export class RegistrationModule {}
