import { ApiProperty } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import { IsArray, IsDateString, IsEnum, IsInt, IsOptional, ValidateNested } from 'class-validator';
import { RegistrationAnswerDto } from './create-registration.dto';
import { RegistrationStatusEnum } from 'src/common/enum/registration-status.enum';

export class UpdateRegistrationDto {
  @ApiProperty({ description: 'Program registration ID' })
  @IsInt()
  programRegistrationId: number;

  @ApiProperty({ description: 'Program ID' })
  @IsInt()
  programId: number;

  @ApiProperty({ description: 'Program Session ID', required: false })
  @IsOptional()
  @IsInt()
  programSessionId?: number;

  @ApiProperty({ enum: RegistrationStatusEnum, required: false })
  @IsOptional()
  @IsEnum(RegistrationStatusEnum)
  registrationStatus?: RegistrationStatusEnum;

  @ApiProperty({
    description: 'Form section ID being updated',
    example: 2,
    type: 'integer'
  })
  @IsOptional()
  @IsInt()
  formSectionId: number;

  @ApiProperty({ type: [RegistrationAnswerDto] })
  @IsArray()
  @IsOptional()
  @ValidateNested({ each: true })
  @Type(() => RegistrationAnswerDto)
  answers: RegistrationAnswerDto[];

  @ApiProperty({ required: false, description: 'Cancellation date (for cancellation requests)' })
  @IsOptional()
  @IsDateString()
  cancellationDate?: Date;

  @ApiProperty({ required: false, description: 'ID of user who cancelled (for cancellation requests)' })
  @IsOptional()
  @IsInt()
  cancelledBy?: number;
}