import { Injectable } from '@nestjs/common';
import { CreateRegistrationTravelPlanDto } from './dto/create-registration-travel-plan.dto';
import { UpdateRegistrationTravelPlanDto } from './dto/update-registration-travel-plan.dto';
import { RegistrationTravelPlanRepository } from './registration-travel-plan.repository';
import { AppLoggerService } from 'src/common/services/logger.service';
import { handleKnownErrors } from 'src/common/utils/handle-error.util';
import { ERROR_CODES } from 'src/common/constants/error-string-constants';
import { registrationTravelPlanMessages } from 'src/common/constants/strings-constants';

@Injectable()
export class RegistrationTravelPlanService {
  constructor(
    private readonly repo: RegistrationTravelPlanRepository,
    private readonly logger: AppLoggerService,
  ) {}

  async create(dto: CreateRegistrationTravelPlanDto) {
    this.logger.log(registrationTravelPlanMessages.CREATE_REQUEST_RECEIVED, dto);
    try {
      return await this.repo.createEntity(dto);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.REGISTRATION_TRAVEL_PLAN_SAVE_FAILED, error);
    }
  }

  async findAll(limit: number, offset: number) {
    this.logger.log(registrationTravelPlanMessages.FIND_ALL_REQUEST_RECEIVED);
    try {
      return await this.repo.findAll(limit, offset);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.REGISTRATION_TRAVEL_PLAN_GET_FAILED, error);
    }
  }

  async findOne(id: number) {
    this.logger.log(registrationTravelPlanMessages.FIND_ONE_REQUEST_RECEIVED);
    try {
      return await this.repo.findOne(id);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.REGISTRATION_TRAVEL_PLAN_FIND_BY_ID_FAILED, error);
    }
  }

  async update(id: number, dto: UpdateRegistrationTravelPlanDto) {
    this.logger.log(registrationTravelPlanMessages.UPDATE_REQUEST_RECEIVED);
    try {
      return await this.repo.updateEntity(id, dto);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.REGISTRATION_TRAVEL_PLAN_SAVE_FAILED, error);
    }
  }

  async remove(id: number) {
    this.logger.log(registrationTravelPlanMessages.DELETE_REQUEST_RECEIVED);
    try {
      await this.repo.remove(id);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.REGISTRATION_TRAVEL_PLAN_DELETE_FAILED, error);
    }
  }
}
