import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { RegistrationTravelPlan } from 'src/common/entities/registration-travel-plan.entity'; 
import { RegistrationTravelPlanService } from './registration-travel-plan.service';
import { RegistrationTravelPlanController } from './registration-travel-plan.controller';
import { RegistrationTravelPlanRepository } from './registration-travel-plan.repository';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';

@Module({
  imports: [TypeOrmModule.forFeature([RegistrationTravelPlan]), forwardRef(() => AuthModule), forwardRef(() => UserModule)],
  controllers: [RegistrationTravelPlanController],
  providers: [RegistrationTravelPlanService, RegistrationTravelPlanRepository, CommonDataService, AppLoggerService],
  exports: [RegistrationTravelPlanService, RegistrationTravelPlanRepository],
})
export class RegistrationTravelPlanModule {}
