import { ApiProperty } from '@nestjs/swagger';
import { IsEnum, IsInt, IsOptional, IsString } from 'class-validator';
import { IdTypeEnum } from 'src/common/enum/proof-id-type.enum';
import { TshirtSizeEnum } from 'src/common/enum/tshirt-size.enum';
import { TravelStatusEnum } from 'src/common/enum/travel-status.enum';

export class CreateRegistrationTravelInfoDto {
  @ApiProperty()
  @IsInt()
  registrationId: number;

  @ApiProperty({ enum: IdTypeEnum })
  @IsEnum(IdTypeEnum)
  idType: IdTypeEnum;

  @ApiProperty()
  @IsString()
  idNumber: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  idPictureUrl?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  userPictureUrl?: string;

  @ApiProperty({ enum: TshirtSizeEnum, required: false })
  @IsOptional()
  @IsEnum(TshirtSizeEnum)
  tshirtSize?: TshirtSizeEnum;

  @ApiProperty({ enum: TravelStatusEnum, required: false })
  @IsOptional()
  @IsEnum(TravelStatusEnum)
  travelInfoStatus?: TravelStatusEnum;

  @ApiProperty()
  @IsInt()
  createdBy: number;

  @ApiProperty()
  @IsInt()
  updatedBy: number;
}
