import { Injectable } from '@nestjs/common';
import { CreateRegistrationPaymentDetailDto } from './dto/create-registration-payment-detail.dto';
import { UpdateRegistrationPaymentDetailDto } from './dto/update-registration-payment-detail.dto';
import { RegistrationPaymentDetailRepository } from './registration-payment-detail.repository';
import { AppLoggerService } from 'src/common/services/logger.service';
import { handleKnownErrors } from 'src/common/utils/handle-error.util';
import { ERROR_CODES } from 'src/common/constants/error-string-constants';
import { registrationPaymentDetailMessages } from 'src/common/constants/strings-constants';

@Injectable()
export class RegistrationPaymentDetailService {
  constructor(
    private readonly repo: RegistrationPaymentDetailRepository,
    private readonly logger: AppLoggerService,
  ) {}

  async create(dto: CreateRegistrationPaymentDetailDto) {
    this.logger.log(registrationPaymentDetailMessages.CREATE_REQUEST_RECEIVED, dto);
    try {
      return await this.repo.createEntity(dto);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.REGISTRATION_PAYMENT_DETAIL_SAVE_FAILED, error);
    }
  }

  async findAll(limit: number, offset: number) {
    this.logger.log(registrationPaymentDetailMessages.FIND_ALL_REQUEST_RECEIVED);
    try {
      return await this.repo.findAll(limit, offset);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.REGISTRATION_PAYMENT_DETAIL_GET_FAILED, error);
    }
  }

  async findOne(id: number) {
    this.logger.log(registrationPaymentDetailMessages.FIND_ONE_REQUEST_RECEIVED);
    try {
      return await this.repo.findOne(id);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.REGISTRATION_PAYMENT_DETAIL_FIND_BY_ID_FAILED, error);
    }
  }

  async update(id: number, dto: UpdateRegistrationPaymentDetailDto) {
    this.logger.log(registrationPaymentDetailMessages.UPDATE_REQUEST_RECEIVED);
    try {
      return await this.repo.updateEntity(id, dto);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.REGISTRATION_PAYMENT_DETAIL_SAVE_FAILED, error);
    }
  }

  async remove(id: number) {
    this.logger.log(registrationPaymentDetailMessages.DELETE_REQUEST_RECEIVED);
    try {
      await this.repo.remove(id);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.REGISTRATION_PAYMENT_DETAIL_DELETE_FAILED, error);
    }
  }
}
