import { Injectable } from '@nestjs/common';
import { CreateRegistrationInvoiceDetailDto } from './dto/create-registration-invoice-detail.dto';
import { UpdateRegistrationInvoiceDetailDto } from './dto/update-registration-invoice-detail.dto';
import { RegistrationInvoiceDetailRepository } from './registration-invoice-detail.repository';
import { AppLoggerService } from 'src/common/services/logger.service';
import { handleKnownErrors } from 'src/common/utils/handle-error.util';
import { ERROR_CODES } from 'src/common/constants/error-string-constants';
import { registrationInvoiceDetailMessages } from 'src/common/constants/strings-constants';

@Injectable()
export class RegistrationInvoiceDetailService {
  constructor(
    private readonly repo: RegistrationInvoiceDetailRepository,
    private readonly logger: AppLoggerService,
  ) {}

  async create(dto: CreateRegistrationInvoiceDetailDto) {
    this.logger.log(registrationInvoiceDetailMessages.CREATE_REQUEST_RECEIVED, dto);
    try {
      return await this.repo.createEntity(dto);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.REGISTRATION_INVOICE_DETAIL_SAVE_FAILED, error);
    }
  }

  async findAll(limit: number, offset: number) {
    this.logger.log(registrationInvoiceDetailMessages.FIND_ALL_REQUEST_RECEIVED);
    try {
      return await this.repo.findAll(limit, offset);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.REGISTRATION_INVOICE_DETAIL_GET_FAILED, error);
    }
  }

  async findOne(id: number) {
    this.logger.log(registrationInvoiceDetailMessages.FIND_ONE_REQUEST_RECEIVED);
    try {
      return await this.repo.findOne(id);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.REGISTRATION_INVOICE_DETAIL_FIND_BY_ID_FAILED, error);
    }
  }

  async update(id: number, dto: UpdateRegistrationInvoiceDetailDto) {
    this.logger.log(registrationInvoiceDetailMessages.UPDATE_REQUEST_RECEIVED);
    try {
      return await this.repo.updateEntity(id, dto);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.REGISTRATION_INVOICE_DETAIL_SAVE_FAILED, error);
    }
  }

  async remove(id: number) {
    this.logger.log(registrationInvoiceDetailMessages.DELETE_REQUEST_RECEIVED);
    try {
      await this.repo.remove(id);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.REGISTRATION_INVOICE_DETAIL_DELETE_FAILED, error);
    }
  }
}
