import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { CommunicationTrack, ProgramRegistration, RegistrationApproval, RegistrationApprovalTrack } from 'src/common/entities';
import { RegistrationApprovalService } from './registration-approval.service';
import { RegistrationApprovalController } from './registration-approval.controller';
import { RegistrationApprovalRepository } from './registration-approval.repository';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { CommunicationService } from 'src/communication/communication.service';
import { CommunicationRepository } from 'src/communication/communication.repository';
import { AwsS3Service } from 'src/common/services/awsS3.service';

@Module({
  imports: [TypeOrmModule.forFeature([RegistrationApproval, ProgramRegistration, CommunicationTrack,RegistrationApprovalTrack]), forwardRef(() => AuthModule), forwardRef(() => UserModule)],
  controllers: [RegistrationApprovalController],
  providers: [RegistrationApprovalService, RegistrationApprovalRepository, CommonDataService, AppLoggerService, CommunicationService, CommunicationRepository, AwsS3Service],
  exports: [RegistrationApprovalService, RegistrationApprovalRepository],
})
export class RegistrationApprovalModule {}
