import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';
import { IsInt, IsNotEmpty, IsOptional } from 'class-validator';
import { CreateRegistrationApprovalDto } from './create-registration-approval.dto';

export class UpdateRegistrationApprovalDto extends PartialType(
  OmitType(CreateRegistrationApprovalDto, ['createdBy', 'updatedBy', 'registrationId'] as const),
) {
  @ApiProperty()
  @IsInt()
  @IsNotEmpty()
  updatedBy: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsInt()
  allocatedProgramId: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsInt()
  allocatedSessionId: number;

}
