import { ApiProperty } from '@nestjs/swagger';
import { IsEnum, IsNumber } from 'class-validator';
import { ProgramStatusEnum } from 'src/common/enum/program.enums';

export class UpdateProgramStatusDto {
  @ApiProperty({ description: 'Program status', enum: ProgramStatusEnum })
  @IsEnum(ProgramStatusEnum)
  status: ProgramStatusEnum;

  @ApiProperty({ description: 'Updated by user ID', example: 1 })
  @IsNumber()
  updatedBy: number;
}
