import { Module, forwardRef } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import {
  Program,
  ProgramRegistration,
  ProgramRegistrationRmRating,
  ProgramRegistrationRmRatingType,
  ProgramRegistrationSwap,
  ProgramType,
  User,
} from 'src/common/entities';
import { ProgramRegistrationService } from './program-registration.service';
import { ProgramRegistrationController } from './program-registration.controller';
import { ProgramRegistrationRepository } from './program-registration.repository';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { ProgramRegistrationSwapRepository } from './repositories/program-registration-swap.repository';
import { ProgramRegistrationRmRatingRepository } from './repositories/program-registration-rm-rating.repository';
import { ProgramRegistrationRmRatingService } from './services/program-registration-rm-rating.service';
import { ProgramRepository } from 'src/program/program.repository';
import { UserRepository } from 'src/user/user.repository';
import { ProgramTypeRepository } from 'src/program-type/program-type.repository';
import { ProgramModule } from 'src/program/program.module';
import { RegistrationRepository } from 'src/registration/registration.repository';
import { RegistrationModule } from 'src/registration/registration.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([
      Program,
      ProgramType,
      ProgramRegistration,
      ProgramRegistrationRmRatingType,
      ProgramRegistrationRmRating,
      ProgramRegistrationSwap,
      User,
    ]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
    forwardRef(() => ProgramModule),
    forwardRef(() => RegistrationModule),
  ],
  controllers: [ProgramRegistrationController],
  providers: [
    ProgramRegistrationService,
    ProgramRegistrationRepository,
    CommonDataService,
    AppLoggerService,
    ProgramRegistrationRmRatingRepository,
    ProgramRegistrationRmRatingService,
    ProgramRegistrationSwapRepository,
    ProgramRepository,
    UserRepository,
    ProgramTypeRepository,
  ],
  exports: [ProgramRegistrationService, ProgramRegistrationRepository],
})
export class ProgramRegistrationModule {}
