import { ApiProperty } from '@nestjs/swagger';
import { IsBoolean, IsDateString, IsEmail, IsEnum, IsInt, IsOptional, IsString } from 'class-validator';
import { GenderEnum } from 'src/common/enum/gender.enum';

export class CreateProgramRegistrationDto {
  @ApiProperty()
  @IsInt()
  programSessionId: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsInt()
  userId?: number;

  // @ApiProperty({ required: false })
  // @IsOptional()
  // @IsInt()
  // programRegistrationSeqNumber?: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsInt()
  waitingListSeqNumber?: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsDateString()
  cancellationDate?: Date;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsInt()
  cancelledBy?: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsInt()
  rmContact?: number;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  preferredRoomMate?: string;

  @ApiProperty()
  @IsString()
  fullName: string;

  @ApiProperty({ enum: GenderEnum })
  @IsEnum(GenderEnum)
  gender: GenderEnum;

  @ApiProperty()
  @IsString()
  mobileNumber: string;

  @ApiProperty()
  @IsEmail()
  emailAddress: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsDateString()
  dob?: Date;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  city?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsString()
  notes?: string;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsBoolean()
  termsAccepted?: boolean;

  @ApiProperty()
  @IsInt()
  createdBy: number;

  @ApiProperty()
  @IsInt()
  updatedBy: number;
}
