import { forwardRef, Module } from '@nestjs/common';
import { PaymentService } from './payment.service';
import { PaymentController } from './payment.controller';
import { InvoiceService } from 'src/invoice/invoice.service';
import { PaymentRepository } from './payment.repository';
import { TypeOrmModule } from '@nestjs/typeorm';
import { 
  CommunicationTrack,
  Option,
  Preference,
  Program, 
  ProgramQuestion, 
  ProgramRegistration, 
  ProgramRegistrationFailure, 
  ProgramRegistrationSwap, 
  ProgramSession, 
  Question, 
  RegistrationApproval, 
  RegistrationCustomResponse, 
  RegistrationInvoiceDetail,
  RegistrationPaymentDetail,
  RegistrationPaymentDetailsHistory,
  RegistrationQuestionAnswer,
  ProgramRegistrationRmRating,
  RegistrationTravelPlan,
  RegistrationTravelInfo,
} from 'src/common/entities';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { RegistrationService } from 'src/registration/registration.service';
import { RegistrationRepository } from 'src/registration/registration.repository';
import { PreferenceModule } from 'src/preference/preference.module';
import { CommunicationService } from 'src/communication/communication.service';
import { ProgramRegistrationRepository } from 'src/program-registration/program-registration.repository';
import { CommunicationRepository } from 'src/communication/communication.repository';
import { ExcelService } from 'src/common/services/excel.service';
import { AwsS3Service } from 'src/common/services/awsS3.service';
import { ProgramRegistrationSwapRepository } from 'src/program-registration/repositories/program-registration-swap.repository';
import { ProgramRegistrationModule } from 'src/program-registration/program-registration.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([
  RegistrationPaymentDetail,
  RegistrationPaymentDetailsHistory,
  RegistrationInvoiceDetail,
  ProgramRegistration,
  ProgramSession,
  Program,
  Question,
  Option,
  RegistrationApproval,
  ProgramQuestion,
  RegistrationCustomResponse,
  ProgramRegistrationFailure,
  CommunicationTrack,
  Preference,
  ProgramRegistrationSwap,
  RegistrationQuestionAnswer,
  ProgramRegistrationRmRating,
    RegistrationTravelPlan,
    RegistrationTravelInfo
    ]),
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
    forwardRef(()=> PreferenceModule),
    forwardRef(() => ProgramRegistrationModule)
  ],
  controllers: [PaymentController],
  providers: [
    PaymentService, 
    InvoiceService, 
    PaymentRepository, 
    CommonDataService, 
    AppLoggerService,
    RegistrationService,
    RegistrationRepository,
    CommunicationService,
    ProgramRegistrationRepository,
    CommunicationRepository,
    ExcelService,
    AwsS3Service,
    ProgramRegistrationSwapRepository
  ],
  exports: [PaymentService, PaymentRepository, ExcelService],
})
export class PaymentModule {}