// dto/create-question-option.dto.ts
import { IsString, IsEnum, IsInt, IsOptional } from 'class-validator';
import { OptionType } from 'src/common/enum/option-type.enum'; 
import { ApiProperty } from '@nestjs/swagger';

export class CreateOptionDto {
  @ApiProperty()
  @IsString({ message: 'The name must be a valid string.' })
  name: string;

  @ApiProperty({ enum: OptionType })
  @IsEnum(OptionType, { message: 'The type must be a valid option type.' })
  type: OptionType;

  @ApiProperty({ required: false })
  @IsOptional()
  @IsInt({ message: 'The category ID must be a valid integer if provided.' })
  categoryId: number | null;


  @ApiProperty({ required: false })
  @IsOptional()
  @IsString({ message: 'The status must be a valid string if provided.' })
  status: string;

  @ApiProperty()
  @IsInt({ message: 'The createdBy field must be a valid integer.' })
  createdBy: number;

  @ApiProperty()
  @IsInt({ message: 'The updatedBy field must be a valid integer.' })
  updatedBy: number;
}