import { Module, forwardRef } from '@nestjs/common';
import { OptionCategoryService } from './option-category.service';
import { OptionCategoryController } from './option-category.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Option, OptionCategory, User } from 'src/common/entities';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { OptionCategoryRepository } from './option-category.repository';

@Module({
  imports: [TypeOrmModule.forFeature([Option, OptionCategory,User]),forwardRef(() => AuthModule), forwardRef(() => UserModule)],
  controllers: [OptionCategoryController],
  providers: [OptionCategoryService, OptionCategoryRepository],
})
export class OptionCategoryModule {}
