import { IsNotEmpty, IsNumber, IsString } from 'class-validator';
import { Type } from 'class-transformer';

export class CreateMessageDto {
  @IsNotEmpty()
  @IsNumber()
  @Type(() => Number)
  programId: number;

  @IsNotEmpty()
  @IsNumber()
  @Type(() => Number)
  seekerId: number;

  @IsNotEmpty()
  @IsNumber()
  @Type(() => Number)
  receiverId: number;

  @IsNotEmpty()
  @IsString()
  content: string;
}
