import { Injectable } from '@nestjs/common';
import { LookupDataRepository } from './lookup-data.repository';
import { AppLoggerService } from 'src/common/services/logger.service';
import { lookupDataConstMessages } from 'src/common/constants/strings-constants';
import { ERROR_CODES } from 'src/common/constants/error-string-constants';
import { handleKnownErrors } from 'src/common/utils/handle-error.util';

@Injectable()
export class LookupDataService {
  constructor(
    private readonly repository: LookupDataRepository,
    private readonly logger: AppLoggerService,
  ) {}

  async findActiveByCategory(category: string) {
    this.logger.log(lookupDataConstMessages.FINDING_BY_CATEGORY(category));
    try {
      return await this.repository.findActiveByCategory(category);
    } catch (error) {
      handleKnownErrors(ERROR_CODES.LOOKUP_DATA_GET_FAILED, error);
    }
  }

  async findCategories() {
    this.logger.log(lookupDataConstMessages.FINDING_CATEGORIES);
    try {
      return await this.repository.findActiveCategories();
    } catch (error) {
      handleKnownErrors(ERROR_CODES.LOOKUP_DATA_GET_FAILED, error);
    }
  }
}
