import { forwardRef, Module } from '@nestjs/common';
import { InvoiceService } from './invoice.service';
import { InvoiceController } from './invoice.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { CommunicationTrack, ProgramRegistration, RegistrationInvoiceDetail, RegistrationPaymentDetail } from 'src/common/entities';
import { CommonDataService } from 'src/common/services/commonData.service';
import { AppLoggerService } from 'src/common/services/logger.service';
import { CommunicationService } from 'src/communication/communication.service';
import { AuthModule } from 'src/auth/auth.module';
import { UserModule } from 'src/user/user.module';
import { PreferenceModule } from 'src/preference/preference.module';
import { CommunicationRepository } from 'src/communication/communication.repository';
import { AwsS3Service } from 'src/common/services/awsS3.service';

@Module({
  imports: [TypeOrmModule.forFeature([RegistrationInvoiceDetail,RegistrationPaymentDetail, ProgramRegistration ,CommunicationTrack]), 
    forwardRef(() => AuthModule),
    forwardRef(() => UserModule),
    forwardRef(()=> PreferenceModule),
  ], 
  controllers: [InvoiceController],
  providers: [InvoiceService, CommonDataService, AppLoggerService, CommunicationService, CommunicationRepository,AwsS3Service],
  exports: [InvoiceService],
})
export class InvoiceModule {}
