import { Injectable } from '@nestjs/common';
import { FeatureFlagRepository } from './feature-flag.repository';
import { AppLoggerService } from 'src/common/services/logger.service';
import { featureFlagMessages } from 'src/common/constants/strings-constants';

@Injectable()
export class FeatureFlagService {
  constructor(
    private readonly repository: FeatureFlagRepository,
    private readonly logger: AppLoggerService,
  ) {}

  async getActiveFlags() {
    this.logger.log(featureFlagMessages.FETCHING_ACTIVE_FLAGS);
    return this.repository.findActiveFlags();
  }
}
