import { IsString, IsOptional, IsArray, IsObject, IsBoolean } from 'class-validator';
import { Type } from 'class-transformer';
import { ValidateNested } from 'class-validator';
import { TrackInfo } from './email-communication.dto';

export class WhatsAppParameter {
  @IsString()
  name: string;

  @IsString()
  value: string;
}

export class SendTemplateMessageDto {
  @IsString()
  whatsappNumber: string;

  @IsString()
  templateName: string;

  @IsString()
  broadcastName: string;

  @IsOptional()
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => WhatsAppParameter)
  parameters?: WhatsAppParameter[];

  @IsOptional()
  @ValidateNested()
  @Type(() => TrackInfo)
  trackinfo?: TrackInfo;
}

export class SendSessionMessageDto {
  @IsString()
  whatsappNumber: string;

  @IsString()
  message: string;
}

export class WhatsAppWebhookDto {
  @IsString()
  eventType: 'sent' | 'delivered' | 'read' | 'failed' | 'message';

  @IsString()
  whatsappNumber: string;

  @IsOptional()
  @IsString()
  senderName?: string;

  @IsOptional()
  @IsString()
  message?: string;

  @IsOptional()
  @IsString()
  messageId?: string;

  @IsString()
  timestamp: string;

  @IsOptional()
  @IsString()
  status?: string;

  @IsOptional()
  @IsBoolean()
  isGroup?: boolean;

  @IsOptional()
  @IsObject()
  data?: Record<string, any>;
}

export class SendBulkTemplateMessageDto {
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => BulkWhatsAppRecipient)
  recipients: BulkWhatsAppRecipient[];

  @IsString()
  templateName: string;

  @IsString()
  broadcastName: string;

  @IsOptional()
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => WhatsAppParameter)
  globalParameters?: WhatsAppParameter[];
}
export class BulkWhatsAppRecipient {
  @IsString()
  whatsappNumber: string;

  @IsOptional()
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => WhatsAppParameter)
  customParams?: WhatsAppParameter[];
}