import { IsNotEmpty, IsNumber, IsEnum, IsOptional, IsString } from 'class-validator';
import { Type } from 'class-transformer';
import { CommunicationTypeEnum } from 'src/common/enum/communication-type.enum';
import { CommunicationStatusEnum } from 'src/common/enum/communication-status.enum';
import { OmitType, PartialType } from '@nestjs/swagger';

export class CreateCommunicationTrackDto {
  @IsNotEmpty()
  @IsNumber()
  @Type(() => Number)
  registrationId: number;

  @IsNotEmpty()
  @IsEnum(CommunicationTypeEnum)
  typ: CommunicationTypeEnum;

  @IsOptional()
  @IsEnum(CommunicationStatusEnum)
  stats?: CommunicationStatusEnum;

  @IsOptional()
  @IsString()
  failedReason?: string;

  @IsNotEmpty()
  @IsNumber()
  @IsOptional()
  @Type(() => Number)
  createdBy?: number;

  @IsNotEmpty()
  @IsNumber()
  @IsOptional()
  @Type(() => Number)
  updatedBy?: number;
}

export class UpdateCommunicationTrackDto extends PartialType(
    OmitType(CreateCommunicationTrackDto, ['createdBy'] as const)
  ) {
    @IsOptional()
    @IsNumber()
    @Type(() => Number)
    registrationId?: number;
  
    @IsOptional()
    @IsEnum(CommunicationTypeEnum)
    typ?: CommunicationTypeEnum;
  
    @IsOptional()
    @IsEnum(CommunicationStatusEnum)
    stats?: CommunicationStatusEnum;
  
    @IsOptional()
    @IsString()
    failedReason?: string;
  
    @IsOptional()
    @IsNumber()
    @Type(() => Number)
    updatedBy?: number;
  }