import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { HttpModule } from '@nestjs/axios';
import { CommunicationService } from './communication.service';
import { CommunicationController } from './communication.controller';
import { communicationConfig } from './config/communication.config';
import { TypeOrmModule } from '@nestjs/typeorm';
import { CommunicationTrack } from 'src/common/entities';
import { AppLoggerService } from 'src/common/services/logger.service';
import { CommunicationRepository } from './communication.repository';

@Module({
  imports: [
    // ConfigModule.forFeature(communicationConfig),
    // HttpModule,
    TypeOrmModule.forFeature([CommunicationTrack]),
  ],
  providers: [CommunicationService, AppLoggerService, CommunicationRepository],
  controllers: [CommunicationController],
  exports: [CommunicationService,CommunicationRepository],
})
export class CommunicationModule {}
